﻿import mx.controls.ComboBox;
import mx.controls.NumericStepper;
import mx.controls.CheckBox;

import Cons;

/**
 * The ControlPanel contains the buttons etc that allow the user to
 * change the group, current color, etc.
 */
class ControlPanel extends MovieClip{
    //var kali:Kali;
    var colorNames:Array = [
      "black",
      "red",
      "yellow",
      "green",
      "lightBlue",
      "Blue"
      ];
    var colors:Array = [
      0, 			//Color.black,
      0xff0000, 	//Color.red,
      0xffff00,		//Color.yellow,
      0x00ff00,		//Color.green,
      (173*256+ 216*16+ 230),	// light blue
      0x0000ff
      ];
	var groupCombo:ComboBox;
	var tSteppers:Array;
	var showTCheck:CheckBox;
    var currentColor:Number;
    var currentGroup:Number;
    var wallpaperString:String  = "Wallpaper Groups";
    var friezeString:String  = "Frieze Groups";
    var rosetteString:String  = "Rosette Groups";
    var drawPanel:DrawPanel;
    var panorama:Panorama;
	var kaliCanvas:KaliCanvas;


    /**
     * Create a new control panel object.
     * @param	kali		The Kali object for this applet
     * @param	drawPanel	The DrawPanel object for this applet
     * @param	panorama	The Panorama object for this applet
     */
    public function ControlPanel() { //_groupCombo:ComboBox, _tSteppers:Array, _dp:DrawPanel, _panorama:Panorama, _kaliCanvas:KaliCanvas) {

		groupCombo = this["groupCombo"];
		tSteppers = [this["t0Stepper"]];
		showTCheck = this["showTCheck"];
		//trace(groupCombo + ":" + tSteppers[0]+":"+showTCheck);
		
		//drawPanel = _dp;
		//panorama = _panorama;
		//kaliCanvas = _kaliCanvas;
		//tSteppers = [tStepper0];
		
		currentGroup = groupCombo.selectedItem.data;
		currentColor = 0;
		
	}
	
	public function init():Void {
		// Initialise EventListeners
		groupCombo.addEventListener("change", this);
		for(var t=0; t < tSteppers.length; t++) {
			var s:NumericStepper = NumericStepper(tSteppers[t]);
			s.addEventListener("change", this);
		}
	}
	
	public function showTranslations():Boolean {
		//trace("showTCheck = " + showTCheck.selected);
		return showTCheck.selected;
	}
	
	public function change(evt:Object) {
		//
		if(evt.target == groupCombo) {
			//trace("drawPanel="+drawPanel);
			drawPanel.clear();
			panorama.setGroup(evt.target.selectedItem.data);
		}
		else if (evt.target == tSteppers[0]) {
			kaliCanvas.clear();
			panorama.tOffsets[0] = evt.target.value*10;
			drawPanel.repaint();
		}
	}
}
