﻿/**
 * Kali Constants
 */
class Cons {
  
  //
  //  The AXIS_ values give the possible axes for elementary
  //  reflections and glide reflections.
  //
  public static var AXIS_NONE:Number = 1;	//	no symmetry of the given type
  public static var AXIS_X0:Number = 2;   //      x ==  0   
  public static var AXIS_X4:Number = 3;	//      x == 1/4  
  public static var AXIS_Y0:Number = 4;	//      y ==  0   
  public static var AXIS_Y4:Number = 5;	//      y == 1/4  

  public static var GROUPTYPE_WALLPAPER:Number = 0;
  public static var GROUPTYPE_FRIEZE:Number = 1;
  public static var GROUPTYPE_ROSETTE:Number = 2;

  //	The GROUP_ values define names for the wallpaper groups
  //	using Conway's notation.
  //
  //		'o' stands for "wallpaper",
  //		'f' stands for "frieze", and
  //		'r' stands for "rosette".
  //
  //	I've had to deviate from Conway's notation to express
  //	everything using only letters and numbers.
  //
  //		Conway's	this
  //		notation	enum
  //
  //		   ¥		 t  ("torus")
  //		   o		 o
  //		   *		 x
  //		   °		 i  ("infinity")
  //
  // IMPORTANT NOTE: parts of the Kali source code make use of the
  //   fact that the values of these GROUP_* constants are consectuve
  //   integers starting with 0; in particular, these values are used
  //   as indices into arrays of objects corresponding to the groups.
  //
  //
  //	wallpaper groups
  //
  public static var GROUP_w2222:Number = 0;
  public static var GROUP_w333:Number = 1;
  public static var GROUP_w442:Number = 2;
  public static var GROUP_w632:Number = 3;
  public static var GROUP_wx2222:Number = 4;
  public static var GROUP_wx333:Number = 5;
  public static var GROUP_wx442:Number = 6;
  public static var GROUP_wx632:Number = 7;
  public static var GROUP_w4x2:Number = 8;
  public static var GROUP_w3x3:Number = 9;
  public static var GROUP_w2x22:Number = 10;
  public static var GROUP_w22x:Number = 11;
  public static var GROUP_wxx:Number = 12;
  public static var GROUP_wxo:Number = 13;
  public static var GROUP_woo:Number = 14;
  public static var GROUP_w22o:Number = 15;
  public static var GROUP_wt:Number = 16;

  //
  //	frieze groups
  //
  public static var GROUP_fii:Number = 17;
  public static var GROUP_fix:Number = 18;
  public static var GROUP_fxii:Number = 19;
  public static var GROUP_f22i:Number = 20;
  public static var GROUP_fx22i:Number = 21;
  public static var GROUP_f2xi:Number = 22;
  public static var GROUP_fio:Number = 23;

  //
  //	rosette groups
  //
  public static var GROUP_r1:Number = 24;
  public static var GROUP_r2:Number = 25;
  public static var GROUP_r3:Number = 26;
  public static var GROUP_r4:Number = 27;
  public static var GROUP_r5:Number = 28;
  public static var GROUP_r6:Number = 29;
  public static var GROUP_rx1:Number = 30;
  public static var GROUP_rx2:Number = 31;
  public static var GROUP_rx3:Number = 32;
  public static var GROUP_rx4:Number = 33;
  public static var GROUP_rx5:Number = 34;
  public static var GROUP_rx6:Number = 35;

  //
  // Some math constants
  //
  public static var ROOT2:Number = 1.41421356237309504880;
  public static var ROOT3:Number = 1.73205080756887729352;
  public static var COS2PIOVER5:Number = 0.30901699437494742410;
  public static var SIN2PIOVER5:Number = 0.95105651629515357211;

  public static var MIN_TRANSLATION:Number = 10.0;
  public static var MIN_AREA:Number = 100.0;
  public static var MIN_ALTITUDE:Number = 5.0;
  
}
