﻿// jbumUI
//
// Jim's basic GUI (we don't need no stinking components!)
//
// It's QUICK and its DIRTY and its UGLY - but it kinda works

MovieClip.prototype.setupSlider = function(lab,min,max,val,changeFunc)
{

   this.minv = min;
   this.maxv = max;
   this.range = max - min;
   this.val = val;
   this.changeFunc = changeFunc;
   this.its_label.text = lab;
   this.knob_mc.useHandCursor = true;
   this.knob_mc._x = (this.val - this.minv)*this.bar_mc._width/this.range;
   this.setTextVal = function()
   {
	  if (this.range < 1)
		  this.its_value.text = Math.round(this.val*1000)/1000;
	  else if (this.range < 10)
		  this.its_value.text = Math.round(this.val*100)/100;
	  else if (this.range < 50)
		  this.its_value.text = Math.round(this.val*10)/10;
	  else
		  this.its_value.text = Math.round(this.val);
   }
   this.setTextVal();
   this.changeFunc(this.val);

   this.onMouseMove = function() 
   {
	  if (!this.dragging)
		return;
	  x = this.knob_mc._x;
	  var r = x/this.bar_mc._width;
	  this.val = this.minv + r*this.range;
	  this.setTextVal();
	  this.changeFunc(this.val);
   };
   this.knob_mc._xscale = this.knob_mc._yscale = 90;
   this.knob_mc.onRollOver = function() { this._xscale = this._yscale = 100; };
   this.knob_mc.onRollOut = function() { this._xscale = this._yscale = 90; };
   this.knob_mc.onPress = function() { this._parent.dragging = true; this.startDrag(false,0,this._y,this._parent.bar_mc._width,this._y); };
   this.knob_mc.onReleaseOutside = this.knob_mc.onRelease = function() { this._parent.dragging = false; this.stopDrag(); };
}

MovieClip.prototype.setupSpring = function()
{
	this.speed = 0;   // current tween velocity
	this.tScale = this._xscale; // target scale
	this.stiffness = .4;
	this.damping = .8;
	this.springIt = function()
	{
		var ds = this.tScale - this._xscale;
		this.speed += ds*this.stiffness;
		this.speed *= this.damping;
		this._xscale += this.speed;
		this._yscale += this.speed;
		if (Math.abs(this.speed) < .001) 
		{
			this._xscale = this._yscale = this.tScale;
			this.onEnterFrame = undefined;
		}
	}
	this.onRollOver = function() {		this.tScale = 100;		this.onEnterFrame = this.springIt;}
	this.onRollOut = function() {		this.tScale = 90;		this.onEnterFrame = this.springIt;}
}

MovieClip.prototype.setupButton = function(lab, pressFunc, isSpring)
{
	this._xscale = this._yscale = 90;
	this.label_txt.text = lab;
	this.label_txt.textColor = 0x000000;
	this.light_mc._alpha = 0;
	this.useHandCursor = true;
	this.pressFunc = pressFunc;
	this.onRollOver = function() { this._xscale = this._yscale = 100; }
	this.onRelease = function() { this.pressFunc(); this.label_txt.textColor = 0x000000; };
	this.onRollOut = this.onReleaseOutside = function() { this._xscale = this._yscale = 90; };
	if (isSpring)
		this.setupSpring();
}

Movieclip.prototype.setupToggleButton = function(lab, initState, toggleFunc, isSpring)
{
	this.label_txt.text = lab;
	this.state = initState;
	this.useHandCursor = true;
	this.toggleFunc = toggleFunc;
	this._xscale = this._yscale = 90;
    this.setState = function(s)
		{
			this.state = s;
			this.toggleFunc(this.state);
			this.showState(); 
		};

	this.showState = function() { this.label_txt.textColor = this.state?  0xFF6666 : 0x000000; 
								 };
	this.onRollOver = function() { this._xscale = this._yscale = 100; }
	this.onRelease = function() { this.setState(!this.state); };
	this.onRollOut = this.onReleaseOutside = function () {  this._xscale = this._yscale = 90; this.showState } ;
	this.showState();
	
	if (isSpring)
		this.setupSpring();
}

Movieclip.prototype.setupRadioButton = function(lab, initState, setmodeFunc, modeNbr, isSpring)
{
	this._xscale = this._yscale = 90;
	this.label_txt.text = lab;
	this.state = initState;
	this.useHandCursor = true;
	this.setmodeFunc = setmodeFunc;
	this.modeNbr = modeNbr;

	this.setState = function(s)
	{
		this.state = s;
		this.showState(); 
	};

	this.showState = function() { this.label_txt.textColor = this.state?  0x66FF66 : 0x000000; 
								 };
	this.onRollOver = function() { this._xscale = this._yscale = 100; }
	this.onRelease = function() { this.setModeFunc(this.modeNbr); };
	this.onRollOut = this.onReleaseOutside = function () {  this._xscale = this._yscale = 90; this.showState } ;
	this.showState();
	if (isSpring)
		this.setupSpring();
}