﻿class Vector {
	var x:Number = 0;
	var y:Number = 0;
	function Vector(p:Object) {
		x = p.x;
		y = p.y;
	}
	function unit():Vector {
		var len = this.length();
		if(len < 0.0001) {
			var a = Math.random()*Math.PI*2;
			return new Vector({x:Math.cos(a), y:Math.sin(a)});
		}
		return new Vector({x:_x/len, y:_y/len});
	}
	function length():Number {
		return Math.sqrt(x*x+y*y); 
	}
	function plus(v:Vector):Vector {
		return new Vector({x:(x+v.x), y:(y+v.y)});
	}
	function minus(v:Vector):Vector {
		return new Vector({x:(x-v.x), y:(y-v.y)});
	}
	function negate():Vector {
		return new Vector({x:-x, y:-y});
	}
	function times(s:Number):Vector {
		return new Vector({x:s*x, y:s*y});
	}
	function dot(v:Vector):Number {
		return x*v.x + y*v.y;
	}
	function crozz(v:Vector):Number {
		return (v.x*y - v.y*x);
	}
	function hasValue():Boolean {
		return !(isNaN(x) || isNaN(y));
	}
}