﻿class ThreeDice extends BaseExperiment implements Experiment {
	
	var dice:Array;
	var xcentres:Array;
	var ycentres:Array;
	
	function init():Void {
		super.init();
		dice = [this["die1"], this["die2"], this["die3"]];
		xcentres = [dice[0]._x, dice[1]._x, dice[2]._x];
		ycentres = [dice[0]._y, dice[1]._y, dice[2]._y];
	}

	public function runOnce():Object {
		var a:Array = [];
		for(var i = 0; i < dice.length; i++) {
			var r = Math.floor(Math.random()*6 + 1);
			//trace(r);
			dice[i].gotoAndStop(r);
			dice[i]._x = xcentres[i]+(Math.random()-0.5)*30;
			dice[i]._y = ycentres[i]+(Math.random()-0.5)*30;
			dice[i]._rotation = Math.random()*90;
			a.push(r);
		}
		return a;
	}
	

	// Run the experiment fast with minimal or no animation
	function runFast():Object {
		
		var a:Array = [];
		for(var i = 0; i < dice.length; i++) {
			var r = Math.floor(Math.random()*6 + 1);
			//dice[i].gotoAndStop(r);
			a.push(r);
		}
		return a;
	}
	
	function sixes(result:Object):Number {
		var s:Number = 0;
		//trace(result);
		for(var i = 0; i < result.length; i++) {
			if(result[i] == 6) {
				s++;
			}
		}
		return s;
	}
	
	// Convert experimental result objects to useful things
	function getScore(result:Object):Number {
		return sixes(result)*2 - 1;		
	}
	
	// Convert experimental result objects to useful things
	function getLabel(result:Object):String {
		return (sixes(result) > 0) ? "Win" : "Lose";		
	}
}
