﻿import BaseExperiment;
import Bead;
import Config;
import Experiment;
import Tumbler;
import ConfiguredExperiment;
import ScrolledLogger;
class OddsOrSixes extends ConfiguredExperiment implements Experiment {
	//
	// Result
	//
	var tania:Number = 0;
	var derek:Number = 0;
	var log:ScrolledLogger = null;
	function init():Void {
		super.init();
		setup();
	}
	function setup() {
		log = ScrolledLogger(_level0.results.log);
		//trace("log = "+ log);
		log.resetCallback = this.resetScores;
		log.resetThisObject = this;
	}
	function done():Void {
		if(log==null) {
			setup();
		}
		getScore = function(holes:Object):Number {
			return Number(holes[0].bead.name);
			/*
			var r:String = holes[0].bead.idref;
			if(r=="Die1" || r=="Die3" || r=="Die5") {
				return 1;
			}
			else if(r=="Die6") {
				return -1;
			}
			else {
				return 0;
			}
			*/
		}
		getLabel = function(holes:Object):String {
			var r:String = holes[0].bead.idref;
			if(r=="Die1" || r=="Die3" || r=="Die5") {
				return "Tania has won "+textScore(tania);
			}
			else if(r=="Die6") {
				return "Derek has won "+textScore(derek);
			}
			else {
				return "----";
			}
		}
		var rv:Number = Number(holes[0].bead.name);
		if(rv == 6) {
			++derek;
		}
		if(rv % 2 == 1) {
			++tania;
		}
		_level0.log(this, holes);
	}
	//
	// Run the experiment fast with minimal or no animation
	//
	function runFast():Object {
		if(log == null) {
			setup();
		}
		getScore = function(s:Object):Number {
			var n:Number = Number(s);
			return n;
			/*
			if(n % 2 == 1) {
				return 1;
			}
			else if(n == 6) {
				return -1;
			}
			else {
				return 0;
			}
			*/
		}
		getLabel = function(s:String):String {
			var n:Number = Number(s);
			if(n % 2 == 1) {
				return "Tania has won "+textScore(tania);
			}
			else if(n == 6) {
				return "Derek has won "+textScore(derek);
			}
			else {
				return "----";
			}
		}
		var rv:Number = Math.floor(1+6*Math.random());
		if(rv == 6) ++derek;
		if(rv % 2 == 1) ++tania;
		return String(rv);
	}
	function textScore(n:Number):String {
		switch (n) {
			case 1: 
				return "once";
			case 2: 
				return "twice";
			default:
				return "" + n + " times";
		}
	}
	function resetScores():Void {
		//trace("reset");
		tania = 0;
		derek = 0;
	}
}