﻿class GamblersRuin extends BaseExperiment implements Experiment {
	
	var xc:Number;
	var yc:Number;
	var intervalId:Number;
	var results:String = "";
	var running:Boolean = false;
	var coin:MovieClip;
	
	function init():Void {
		super.init();
		coin = this["coin"];
		xc = coin._x;
		yc = coin._y;
		trace(xc);
		trace(yc);
		this["sequence"] = "";
	}

	public function runOnce():Object {
		if(!running) {
			results = "";
			running = true;
			intervalId = setInterval(this, "toss", 1000);
		}
		return null;
	}
	
	// Run the experiment fast with minimal or no animation
	function runFast():Object {
		
		results = "";
		while(true) {
			if(Math.random() < 0.5) {
				results += "H";
				break;
			}
			else {
				results += "T";
			}
		}
		this["sequence"] = results;
		return results;
	}

	public function toss():Void {
		coin._x = xc + (Math.random() - 0.5)*50;
		coin._y = yc + (Math.random() - 0.5)*50;
		coin._rotation = 360*Math.random();
		if(Math.random() < 0.5) {
			trace("Head");
			clearInterval(intervalId);
			coin.gotoAndStop(1);
			//invalidate();
			results += "H";
			running = false;
			done();
		}
		else {
			trace("Tail");
			results += "T";
			coin.gotoAndStop(2);
			//invalidate();
			//setInterval(this, "toss", 500);
		}
		this["sequence"] = results;
	}

	function done():Void {
		_level0.log(this, results);
	}
	
	function sixes(result:Object):Number {
		var s:Number = 0;
		//trace(result);
		for(var i = 0; i < result.length; i++) {
			if(result[i] == 6) {
				s++;
			}
		}
		return s;
	}
	
	// Convert experimental result objects to useful things
	function getScore(result:Object):Number {
		return Math.pow(2, result.length);		
	}
	
	// Convert experimental result objects to useful things
	function getLabel(result:Object):String {
		return "Win";		
	}
}
