﻿interface Experiment {
	//
	// Initialise variables and draw the initial state of any animation
	//
	function init():Void;
	//
	// Animate one run of the experiment. 
	// Return one experimental result in an object
	//
	function runOnce():Object;
	//
	// Simplified or null animation (e.g. an eggtimer icon, or a result counter).
	// Return experimental result in an object
	//
	function runFast():Object;
	//
	// Convert experimental result objects to useful things for display.
	// The result parameter is the same as that returned by a run function.
	//
	// getScore: returns a numerical score for the result
	function getScore(result:Object):Number;
	// getLabel: returns null or a descriptive name for the result 
	// e.g. "Heads".
	function getLabel(result:Object):String;
}