﻿class Config extends XML {
	public var loaded:Boolean = false;
	public var stageW:Number = 550;
	public var stageH:Number = 400;
	//
	public var tumblerClasses:Array;
	public var beadClasses:Array;
	public var experimentClasses:Array;
	public var experiments:Array;
	public var resultsVisible:Boolean = true;
	public var treeVisible:Boolean = true;
	public var logVisible:Boolean = true;
	public var NVisible:Boolean = true;
	public var LabelVisible = true;
	public var ScoreVisible = true;
	public var MeanVisible = true;
	public var StdDevVisible = true;
	public var SumVisible = true;
	public var messages:Array;
	//
	static var easePoints:Array = [0, -0.0002, 0.0003, 0.0013, 0.003, 0.0054, 0.0083, 0.012, 0.0163, 0.0212, 0.0269, 0.0333, 0.0404, 0.0482, 0.0567, 0.0661, 0.0761, 0.087, 0.0987, 0.1111, 0.1244, 0.1385, 0.1543, 0.1722, 0.1929, 0.2169, 0.2454, 0.28, 0.324, 0.385, 0.5, 0.6016, 0.6633, 0.7087, 0.7446, 0.7742, 0.799, 0.8202, 0.8383, 0.8542, 0.8691, 0.8829, 0.8958, 0.9078, 0.9189, 0.9291, 0.9386, 0.9472, 0.9551, 0.9623, 0.9688, 0.9746, 0.9798, 0.9843, 0.9882, 0.9916, 0.9943, 0.9965, 0.9982, 0.9994];
	//
	//
	function Config(){
		super();
		ignoreWhite = true;
		init();
	}
	function init() {
		experimentClasses = new Array();
		experiments = new Array();
	}
	function onLoad(success:Boolean):Void {
		if (!success) {
			trace("config load error("+status+")");
			return;
		}
		//
		// Parse top level element
		//
		var _xml:XMLNode = this.firstChild;
		var i:Number;
		var s:String;
		var b:Boolean;
		
		for (var n = _xml.firstChild; n; n=n.nextSibling) {
			//trace(n.nodeName);
			switch(n.nodeName) {
			case 'experimentClasses':
				//Parse list of experimentClasses
				for(var m=n.firstChild; m; m=m.nextSibling) {
					var id:String = m.attributes["id"];
					//trace("experimentClass id = "+id);
					experimentClasses[id] = m;
					for(var eC=m.firstChild; eC; eC=eC.nextSibling) {
						//trace(eC.nodeName);
						switch(eC.nodeName) {
							case 'tumblerClasses':
								if(m.tumblerClasses == null) {
									m.tumblerClasses = [];
								}
								for(var tC=eC.firstChild; tC; tC=tC.nextSibling) {
									var tid:String = tC.attributes["id"];
									//trace("tC=" + tid);
									m.tumblerClasses[tid] = tC;
								}
								break;
							case 'beadClasses':
								if(m.beadClasses == null) {
									m.beadClasses = [];
								}
								for(var bC=eC.firstChild; bC; bC=bC.nextSibling) {
									var bid:String = bC.attributes["id"];
									//trace("bC=" + bid);
									m.beadClasses[bid] = bC;
								}
								break;
						}
					}
				}
				break;

			case 'experiments':
				//Parse list of experiments
				for(var m=n.firstChild; m; m=m.nextSibling) {
					var id:String = m.attributes["idRef"];
					var name:String = m.attributes["name"];
					trace("experiment name: "+name+ " class: "+id);
					var eC:XMLNode = XMLNode(experimentClasses[id]);
					//trace("eC = " + eC);
					if(eC == null) {
						trace("undefined experiment class: " + id);
						return;
					}
					experiments.push(m);
					if(m.firstChild == null) {
						//trace("no tumblers ");
						continue;
					}
					for(var tumbler=m.firstChild.firstChild; tumbler; tumbler=tumbler.nextSibling) {
						//trace(tumbler.nodeName);
						var idRef = tumbler.attributes["idRef"];
						if(m.tumblers == null) {
							m.tumblers = [];
						}
						m.tumblers[idRef] = tumbler;
						tumbler.beads = parseBeads(eC, tumbler.firstChild);
						tumbler.holes = parseHoles(tumbler.firstChild.nextSibling); 
						var tC:XMLNode = XMLNode(eC.tumblerClasses[idRef]);
						tumbler.a = Number(tC.attributes["a"]);
						tumbler.b = Number(tC.attributes["b"]);
						tumbler.c = Number(tC.attributes["c"]);
						tumbler.lColor = Number("0x"+tC.attributes["lColor"]);
						tumbler.bColor = Number("0x"+tC.attributes["bColor"]);
						tumbler.lThickness = tC.attributes["lThickness"];
						tumbler.x = Number(tumbler.attributes["x"]);
						tumbler.y = Number(tumbler.attributes["y"]);
						tumbler.scale = Number(tumbler.attributes["scale"]);
					}
				}
				break;
			case 'resultPanel':
				resultsVisible = !(n.attributes["visible"]=="false");
				if(resultsVisible) {
					var tree=n.firstChild;
					if(tree != null) {
						treeVisible = !(tree.attributes["visible"]=="false");
						var log=tree.nextSibling;
						if(log != null) {
							logVisible = !(log.attributes["visible"]=="false");
							NVisible = !(log.attributes["N"]=="false");
							LabelVisible = !(log.attributes["Label"]=="false");
							ScoreVisible = !(log.attributes["Score"]=="false");
							MeanVisible = !(log.attributes["Mean"]=="false");
							StdDevVisible = !(log.attributes["StdDev"]=="false");
							SumVisible = !(log.attributes["Sum"]=="false");
						}
					}
				}
				else {
					treeVisible = false;
					logVisible = false;
				}
				//trace("results = "+resultsVisible);
				//trace("tree = "+treeVisible);
				//trace("log = "+logVisible);
				break;
			case 'messages':
				//Parse list of messages
				for(var m=n.firstChild; m; m=m.nextSibling) {
					var s="message["+(m.attributes["name"])+"]";
					s+=m.firstChild.nodeValue;
					//trace(s);
					// create an array of messages with the same name
					var name:String = m.attributes["name"];
					if(messages[name] == null) {
						messages[name] = [];
					}
					messages[name].push({
							text:stripEntities(m.firstChild.nodeValue)
						});
					messages[name].x = 0;
				}
				break;
			}
		}
		
		//
		// Callback to final configuration
		//
		_level0.configure(this);
	}
	function parseBeads(eC:XMLNode, beads:XMLNode):Array {
		//trace("BEADS");
		var a:Array = null;
		for(var m=beads.firstChild; m; m=m.nextSibling) {
			//trace(m.nodeName);
			if(a == null) {
				a = [];
			}
			var idref:String = m.attributes["idref"];
			var name:String = m.attributes["name"];
			//trace("EC BEADCLASSES=" + eC["beadClasses"]);
			//for(var p in eC["beadClasses"]) {
			//	trace("** eC["+p+"]="+eC["beadClasses"][p]);
			//}
			var bC:XMLNode = XMLNode(eC["beadClasses"][idref]);
			var radius = Number(bC.attributes["radius"]);
			//trace("RADIUS = "+radius);
			var id = bC.attributes["id"];
			var icon:String = bC.attributes["icon"];
			var color:Number = null;
			if(icon.indexOf("0x", 0) == 0) {
				color = Number(icon);
				icon = null;
			}
			a.push({idref:idref, name:name, icon:icon, color:color, radius:radius});
		}
		return a;
	}
	function parseHoles(holes:XMLNode):Array {
		//trace("HOLES");
		var a:Array = null;
		for(var m=holes.firstChild; m; m=m.nextSibling) {
			//trace(m.nodeName);
			if(a == null) {
				a = [];
			}
			var x:Number = Number(m.attributes["x"]);
			var y:Number = Number(m.attributes["y"]);
			//trace("(x,y)="+x+","+y);
			a.push({_x:x, _y:y, _alpha:50});
		}
		return a;
	}
	/////////////////////////////////////////////////
	// 
	// Utility function to replace XML entities with their text equivalents
	// &lt; -> <
	// &gt; -> >
	// &apos; -> '
	// &quot; -> "
	// &amp; -> &
	//
	// Needed since XMLSpy/Authentic inserts them (Grrr! - but I suppose it
	// means we don't run the risk of badly formed XML)
	//
	static function stripEntities(msg_str:String):String {
		var i = 0;
		var j = 0;
		var s = "";
		if(msg_str == null || msg_str == undefined) {
			return s;
		}
		while((j=msg_str.indexOf("&",i))>=0) {
			//trace("i="+i+" j="+j);
			s += msg_str.substring(i,j);
			i = msg_str.indexOf(";", j+1);
			if(i<0) {
				// lone '&' - not an entity
				return s + msg_str.substring(j);
			}
			var entity = msg_str.substring(j+1,i++);
			switch(entity) {
				case 'lt':
					s += '<';
					break;
				case 'gt':
					s += '<';
					break;
				case 'apos':
					s += '<';
					break;
				case 'quot':
					s += '<';
					break;
				case 'amp':
					s += '<';
					break;
				default:
					trace("unrecognised entity: &"+ entity +";");
					s += entity;
			}
		}
		s += msg_str.substring(i);
		return s;
	}
	//
	// Messages with the same name are stored in an array. We cycle
	// through these messages as getMessageObject is called.
	//
	public function getMessageObject(name:String):Object {
		var n:Array = messages[name];
		var rv:Object = n[n.x++];
		if(n.x >= n.length) {
			n.x = 0;
			n.nomore = true;
		}
		return rv;
	}
	public function getText(msg:Object):String {
		return msg.text;
	}
	static function ease(t, b, c, d) {
		if (d == 0) {
			t = 1;
		} else {
			t = t/d;
			if (t<0) {
				t = 0;
			}
			if (t>1) {
				t = 1;
			}
		}
		return b+c*easePoints[Math.floor(t*(easePoints.length-1))];
	}
}