﻿class CoinTosses extends BaseExperiment implements Experiment {
	
	//No more than 10 coins. 
	
	static var MAX_COINS:Number = 4;
	
	var toss:TextField;
	
	var coinCount:Number = 0;
	var coins:Array;
	var inMotion:Boolean = false;
	
	function init():Void {
		super.init();
		coins = [];
		for(coinCount = 0; coinCount < MAX_COINS; coinCount++) {
			var aCoin = Coin(attachMovie("Coin", "coin"+coinCount, coinCount));
		
			aCoin._x = 70 + (coinCount % 2)*150;
			aCoin._y = (coinCount > 1 ? 250 : 100);

			aCoin.onPress = function():Void {this.startDrag();}
			aCoin.onRelease = function():Void { stopDrag();}
			coins.push(aCoin);
		}
	}

	public function runOnce():Object {
		
		if (!inMotion) {
			var obj:Object = "";
			inMotion = (coinCount==0) ? false : true;
			//trace("here in runOnce");
			for (var i:Number = 0; i!=coinCount; i++) {
				var s:String = this["coin"+i].toss();
				var b:Boolean = (s=="H") ? true : false;
				obj += s;
			}
		
			//trace("resultString "+obj);
			return obj;
		} else return null;
	}
	

	// Run the experiment fast with minimal or no animation
	function runFast():Object {
		
		//trace("Inside runFast");
		var rv:String = "";
		for (var i:Number = 0; i!=coinCount; i++) {
			var s:String = (Math.random() < 0.5) ? "H" : "T";
			rv += s;
		}
		//trace("resultString "+rv);
		return rv;
	}
	
	function win(result:Object):Boolean {
		var heads:Number = 0;
		//trace(result);
		for(var i = 0; i < result.length; i++) {
			if(result.substr(i,1) == "H") {
				heads++;
			}
		}
		return heads == 2;
	}
	// Convert experimental result objects to useful things
	function getScore(result:Object):Number {
		return win(result) ? 2 : -1;		
	}
	// Convert experimental result objects to useful things
	function getLabel(result:Object):String {
		return win(result) ? "Win" : "Lose";		
	}
}
