﻿import Vector;
class Bead extends MovieClip {
	var id:String;
	var idref:String;
	var name:String;
	var color:Number = 0x00ff00;
	var radius:Number = 20;
	var diameter:Number;
	var v:Vector;
	var s:Vector;
	var frozens:Array;
	var omega:Number = 0;
	var dragging:Boolean = false;
	//
	var tumbler:Tumbler;
	var vx:Number = 0;
	var vy:Number = 0;
	var kDamp:Number = 0.99;
	var kCollisionDamp = 1.7; 
	var replacement:Boolean = false;
	//
	var holed = false;
	var oneHole:Boolean = false;
	var hideFrees:Boolean = false;
	var dimFrees:Boolean = false;
	var initialPosition:Boolean = true;
	//
	function Bead() {
		diameter = 2*radius;
		v = new Vector({x:0,y:0});	
		//s = globalXY();
		//trace("Bead color="+color);
		//trace("Bead radius="+radius);
		//trace("Bead idref="+idref+ " name="+name);
		draw();
	}
	function draw() {
		//trace(radius);
		//holed = false;
		if(initialPosition && tumbler != null) {
			oneHole = (tumbler.holes.length == 1);
			hideFrees = (tumbler.beads.length == tumbler.holes.length);
			dimFrees = (tumbler.beads.length > tumbler.holes.length);
			initialPosition = false;
			var holes:Array = [];
			for(var i:Number = 0; i < tumbler.holes.length; i++) {
				var h:Hole = Hole(tumbler.holes[i]);
				if(h.ibead == null) {
					holes.push(h);
				}
			}
			var ri:Number = Math.floor(Math.random()*holes.length);
			var h:Hole = Hole(holes.splice(ri, 1)[0]);
			if(h != null) {
				h.ifill(this);
				_x = h._x; // - _parent._x;
				_y = h._y; // - _parent._y;
			}
			else {
				var r = Math.random()*100;
				var theta = 2*Math.PI*Math.random();
				_x = 150+r*Math.cos(theta);
				_y = 150+r*Math.sin(theta);
			}
		}
		if(color != null) {
			lineStyle(0, color, 0);
			//beginFill(color,100);
			beginGradientFill("radial", [0xffffff, color, 0x000000], [100, 100, 20], [0, 85, 100], {matrixType:"box", x:-63, y:-63, w:120, h:120, r:(45/180)*Math.PI});
		
			moveTo(radius, 0);
			for(var i = 10; i < 360; i+=10) {
				var theta = i * Math.PI/180;
				lineTo(radius*Math.cos(theta), radius*Math.sin(theta));
			}
			endFill();
		}
		else {
			_alpha = 50;
		}
	}
	function rotateRandom() {
		_rotation += (Math.random()-0.5)*10;
	}
	function globalXY():Vector {
		var p:Object = {x:_x, y:_y};
		_parent.localToGlobal(p);
		return new Vector(p);
	}
	function move2(dt:Number, theta:Number, holes:Array) {
		if(color == null) {
			rotateRandom();
		}
		// damping
		vx *= kDamp;
		vy *= kDamp;
		// gravity
		vx += tumbler.gravity.x;
		vy += tumbler.gravity.y;

		// Object collisions
		var fx = 0;
		var fy = 0;
		for (var i = tumbler.beads.length-1; i >= 0; --i) {
			var b2:Bead = Bead(tumbler.beads[i]);
			if (b2 != this /*&& this.hitTest(b2)*/) {
				var dx = (_x+vx) - b2._x;
				var dy = (_y+vy) - b2._y;
				var dist = Math.sqrt(dx*dx+dy*dy);
				var dmax = radius+b2.radius - dist;
				if (dmax > 0) {
					var mag1 = dmax*kCollisionDamp/dist;
					fx += dx*mag1;
					fy += dy*mag1;
				}
			}
		}
		vx += fx;
		vy += fy;

		// Rim Collisions
		var dx = (_x-tumbler._x+vx);
		var dy = (_y-tumbler._y+vy);
		var a = Math.atan2(dy,dx)-theta+Math.PI/2;
		var dist = Math.sqrt(dx*dx+dy*dy);
		var dmax = dist - (tumbler.pCurve(a)-radius);
		if (dmax > 0) {
			vx -= dx*dmax/dist;
			vy -= dy*dmax/dist;
		}
	
		// Hole Collisions 
		if(!holed && holes != null && holes.length > 0) {
			for(var i = 0; i < holes.length; i++) {
				var hole:Hole = Hole(holes[i]);
				var s:Vector = new Vector({x:_x, y:_y});
				var h:Vector = hole.globalXY();
				//trace("h=("+h.x+","+h.y+") s=("+s.x+","+s.y+") hd="+s.minus(h).length())
				var stillMoving = tumbler.beads.length-tumbler.settledCount;
				//trace("still moving:" + stillMoving);
				if(s.minus(h).length() < radius || (!replacement && holes.length == 1 && stillMoving == 1)) {
				//if(hitTest(hole) || (!oneHole && holes.length == 1)) {
					//trace("HIT");
					//var h:Vector = hole.globalXY();
					//trace("freezing " + name);
					var frozen:MovieClip;
					if(color != null) {
						frozen = this.duplicateMovieClip((_name+i), 5000+frozens.length, {_x:h.x-_parent._x*100/_parent._xscale, _y:h.y-_parent._y*100/_parent._yscale, color:color});
					}
					else {
						frozen = this.duplicateMovieClip((_name+i), 5000+frozens.length, {_x:h.x, _y:h.y, color:color});
					}
					frozen._alpha = 100;
					//trace(frozen._x + "::"+frozen._y);
					//trace("frozens length:" + frozens.length);
					//trace("holes.length =" + holes.length);
					frozens.push(frozen);
					if(dimFrees) {
						_alpha = 20;
					}
					if(hideFrees) {
						_visible = false;
					}
					if(!replacement) {
						holed = true;
					}
					hole.fill(this);
					holes.splice(i, 1);
					++tumbler.settledCount;
					if(holes.length == 0) {
						//trace(_parent);
						for(var j=0; j < tumbler.beads.length; j++) {
							if(hideFrees) {
								tumbler.beads[j]._visible = false;
							}
							else {
								tumbler.beads[j]._alpha = 20;
							}
						}
						//if(frozens.length == 1) {
						//	trace("GOTCHA");
						//}
						tumbler.stopAnimation();
						_parent.done();
					}
					return;
				}
			}
		}
	
		_x += vx;
		_y += vy;
	}
	function onPress() {
		dragging = true;
		this.startDrag();
	}
	function onRelease() {
		dragging = false;
		this.stopDrag();
		s = globalXY();
	}
	function onReleaseOutside() {
		dragging = false;
		this.stopDrag();
		s = globalXY();
	}
}