﻿import mx.controls.NumericStepper;
class Archery extends BaseExperiment implements Experiment {
	var target:MovieClip;
	var tcx:Number;
	var tcy:Number;
	var arrows:Array;
	var xcentres:Array;
	var ycentres:Array;
	static var sd = 40;
	var bow:MovieClip;
	var sight:MovieClip;
	var aimx = 176.55;
	var aimy = 218.55;
	var bowx:Number;
	var bowy:Number;
	var sightx:Number;
	var sighty:Number;
	var stepx:NumericStepper;
	var stepy:NumericStepper;
	var stepx0:Number;
	var stepy0:Number;
	var interval:Number = null;
	
	function init():Void {
		trace("ARCHERY");
		super.init();
		_root["lots_btn"]._visible = false;
		target = this["target"];
		bow = this["bow"];
		bowx=bow._x;
		bowy=bow._y;
		sight = bow["sight"];
		sightx = sight._x;
		sighty = sight._y;
		//trace(bow._x + ","+bow._y);
		//bow._x += 30;
		//bow._y += 40;
		bow.onPress = function() {
			startDrag(false);
		}
		bow.onRelease = bow.onReleaseOutside = function() {
			stopDrag();
			this.snap();
		}
		bow.snap = function() {
			var aimx:Number = _parent.bowx-(_parent.sight._x-_parent.sightx);
			var aimy:Number = _parent.bowy-(_parent.sight._y-_parent.sighty);
			var len:Number = (_x-aimx)*(_x-aimx)+(_y-aimy)*(_y-aimy);
			if(len < 100) {
				_x = aimx;
				_y = aimy;
			}
		}
		tcx = target._x;
		tcy = target._y;
		arrows = [];
		xcentres = [];
		ycentres = [];
		
		_root.run_btn.label = "Shoot";
		_root.lots_btn.label = "Shoot x100";
		_root.clear_btn.label = "Collect";
		var help = attachMovie("ArcheryHelp", "archeryHelp", 25000);
		help._x += 20;
		
		// add in sight steppers
		if(interval==null) {
			interval = setInterval(this, "initLater", 10);
		}
	}

	function initLater() {
		clearInterval(this.interval);
		trace("initLater");
		stepx = this["sx"];
		stepy = this["sy"];
		//trace("stepx="+stepx);
		stepx0 = stepx.value.valueOf();
		stepy0 = stepy.value.valueOf();
		stepx.addEventListener("change", this);
		stepy.addEventListener("change", this);
	}
	
	function change(evt:Object):Void {
		trace(stepx0 + ":" + stepy0);
		if(evt.target == stepx) {
			sight._x = sightx + (stepx.value-stepx0);
		}
		else {
			sight._y = sighty + (stepy.value-stepy0);
		}
	}
	
	
	/*
	Normal deviate - algorithm from Numerical Recipes in C pp289
	*/
	var iset:Number = 0;
	var gset:Number = 0;
	function normal():Number {
		var fac:Number;
		var rsq:Number;
		var v1:Number;
		var v2:Number;
		if(iset == 0) {
			do {
				v1=2*Math.random() - 1;
				v2=2*Math.random() - 1;
				rsq = v1*v1+v2*v2;
			} while (rsq >= 1 || rsq == 0);
			fac=Math.sqrt(-2*Math.log(rsq)/rsq);
			gset = v1*fac;		// saved deviate for next time
			iset = 1;
			return v2*fac;
		} else {
			iset = 0;
			return gset;		// use saved deviate
		}
	}
	
	// Run the experiment fast with minimal or no animation
	public function runFast():Object {
		var r = sd*normal();
		var theta = 2*Math.PI*Math.random();
		var x = bow._x - aimx + tcx + r*Math.cos(theta);
		var y = bow._y - aimy + tcy + r*Math.sin(theta);
		var result = {x:x, y:y};
		var arrow:MovieClip = attachMovie("Arrow", "arrow"+arrows.length, arrows.length, {_alpha:50});
		arrow._x = result.x;
		arrow._y = result.y;
		arrow._rotation = Math.random()*40-30;
		arrows.push(arrow);
		//this.swapDepths(arrow);
		return result;//{x:x, y:y};
	}
	
	public function runOnce():Object {
		//bow.snap();
		onEnterFrame = animateAim;
		var result:Object = runFast(); 
		//var arrow:MovieClip = attachMovie("Arrow", "arrow"+arrows.length, arrows.length);
		//arrow._x = result.x;
		//arrow._y = result.y;
		//arrow._rotation = Math.random()*40-30;
		//arrows.push(arrow);
		return result;
	}
	
	function animateAim():Void {
		var aimx:Number = bowx-(sight._x-sightx);
		var aimy:Number = bowy-(sight._y-sighty);
		bow._x = 0.1*aimx+0.9*bow._x;
		bow._y = 0.1*aimy+0.9*bow._y;
		if(Math.abs(bow._x -aimx)+Math.abs(bow._y-aimy)<0.5) {
			onEnterFrame = undefined;
		}
	}
	
	// Convert experimental result objects to useful things
	function getScore(result:Object):Number {
		var errx = (result.x - tcx);
		var erry = (result.y - tcy);
		var err = Math.sqrt(errx*errx+erry*erry);
		return (err > 100) ? 0 : (10 - Math.floor(err/10));
	}
	
	// Convert experimental result objects to useful things
	function getLabel(result:Object):String {
		return (getScore(result) > 0) ? "Hit" : "Miss";		
	}
	//
	function clearGraphics():Void {
		//trace("CLEARING arrows =" + arrows + " length="+arrows.length);
		for(var i = 0; i < arrows.length; i++) {
			var a:MovieClip = MovieClip(arrows[i]);
			trace("Removing "+a);
			a.removeMovieClip();
		};
		arrows = [];
		sd = 10+30*Math.random();
		trace("sd="+sd);
		//sd=0;
		//sd *= 0.9;
	}

}
