﻿class trionclass extends MovieClip {
	
	static var topTrion:trionclass;
	static var trions:Array = null;
	
	var x:Number;
	var y:Number;
	var row:Number;
	var column:Number;
	var rotation;
	var offset:Number;
	var type:String;	// are we left or right handed?
	var grid:Array;
	var rectangles:Array;
	var camel:Camel;
	var _inCamel:Boolean = false;
	var colour:Color;
	var colourTransform:Object;
	
	function trionclass() {
		// remember newly created instance
		if(trions == null) {
			trions = [this];
		}
		else {
			trions.push(this);
		}
		
		// It will be on top
		topTrion = this;
		
		// Adjust stack position according to type
		type = _name.indexOf("Left") >= 0 ? "left" : "right";
		trace("type = " + type);
		if(type == "left") {
			offset = +25;
		}
		else {
			offset = -25;
		}
		
		// remember stack position
		x = _x;
		y = _y;
		rotation = _rotation;
		
		// Remember constituent rectangles for convenience later
		rectangles = [this["r1"], this["r2"], this["r3"]];
		
		colour = new Color(this);
		colourTransform = colour.getTransform();
	}
	
	function drag() {
		trace("drag");
		_root.camelEye._alpha = 0;
		camel.pickupTrion(this);
		this.startDrag();
		swapDepths(topTrion);
		topTrion = this;
	}
	
	function rotate(angle:Number):Void {
		_root.camelEye._alpha = 0;
		camel.pickupTrion(this);
		_rotation += angle;
		if(_rotation > 180) {
			_rotation -= 360;
		}
		if(_rotation < -90) {
			_rotation += 360;
		}
		setGrid();
		camel.dropTrion(this, false);
		inCamel = false;
	}

	function doRelease() {
		//trace("doRelease");
		//trace("trionclass: _x="+_x+" _y="+_y + "_rotation=" + _rotation);
		this.stopDrag();
		snap();
	}
	
	function snap():Void {
		_x = roundfit(_x);
		_y = roundfit(_y);
		column = (_x - 75 - camel._x)/50
		row = (_y - 75 - camel._y)/50
		trace("Dropped at: " + row + ", " + column); 
		setGrid();
		if(!camel.dropTrion(this)) {
			// drop failed: send back to pile
			trace("DROP FAILED");
			_x = x;
			_y = y;
			_rotation = rotation;
			row = null;
			column = null;
		}
		if(camel.allDone()) {
			_root.camelEye._alpha = 100;
			_root.sun.gotoAndPlay(2);
		}
	}
	
	function setGrid():Void {
		if(type=="left") {
			switch(_rotation) {
				case 0:
					grid = [[1,1,0],[0,1,1],[0,0,0]];
					break;
				case 90:
					grid = [[0,0,1],[0,1,1],[0,1,0]];
					break;
				case 180:
					grid = [[0,0,0],[1,1,0],[0,1,1]];
					break;
				case -90:
					grid = [[0,1,0],[1,1,0],[1,0,0]];
					break;
				default:
					trace("bad rotation: " + _rotation);
			}
		}
		else {
			switch(_rotation) {
				case 0:
					grid = [[0,1,1],[1,1,0],[0,0,0]];
					break;
				case 90:
					grid = [[0,1,0],[0,1,1],[0,0,1]];
					break;
				case 180:
					grid = [[0,0,0],[0,1,1],[1,1,0]];
					break;
				case -90:
					grid = [[1,0,0],[1,1,0],[0,1,0]];
					break;
				default:
					trace("bad rotation: " + _rotation);
			}
		}
	}
		
	function roundfit(cpoint):Number {
		return 50*Math.round((cpoint-offset)/50)+offset;
	}

	function set inCamel(b:Boolean):Void {
		_inCamel = b;
		if(inCamel) {
			colour.setRGB(0xFF9933);
		}
		else {
			colour.setTransform(colourTransform);
		}
	}
	
	function get inCamel() {
		return _inCamel;
	}
}
