﻿import trionclass;
class Camel extends MovieClip {
	var grid:Array;
	var filled:Array;
	
	function Camel() {
		grid = [];
		grid[0] = [0,1,1,0,0,0,0,0,0];
		grid[1] = [1,1,1,0,1,1,1,0,0];
		grid[2] = [0,1,1,1,1,1,1,1,0];
		grid[3] = [0,1,1,1,1,1,1,1,0];
		grid[4] = [0,0,1,1,1,1,1,1,1];
		grid[5] = [0,0,1,1,0,0,1,1,1];
		grid[6] = [0,0,1,1,0,0,0,1,1];
		grid[7] = [0,0,0,1,0,0,0,1,0];
		
		filled = [];
		for(var i=0; i < grid.length+3; i++) {
			filled[i]=[0,0,0,0,0,0,0,0,0,0];
		}	
	}
	
	function pFilled():Void {
		for(var i=0; i < filled.length; i++) {
			var f = filled[i];
			var s = "";
			for(var j=0; j < f.length; j++) {
				s += ((f[j] != 0) ? f[j] : ((grid[i][j]==1)? "o" : "."));
			}
			trace(s);
		}
	}
	
	function notAvailable(row:Number, column:Number):Boolean {
		trace("["+row+","+column+" grid: " + grid[row][column] + " filled: "+ filled[row][column]);
		return filled[row][column]!=0;
	}
	
	function completelyInsideCamel(trion:trionclass):Boolean {
		var row:Number = trion.row;
		var column:Number = trion.column;
		for(var i = 0; i < trion.grid.length; i++) {
			var trow:Array = trion.grid[i];
			trace("trion.row = " + trow);
			for(var j = 0; j < trow.length; j++) {
				if(trow[j]==1 && grid[row+i][column+j]!=1) {
					return false;
				}
			}
		}
		return true;
	}
	
	function allDone():Boolean {
		for(var i=0; i < grid.length; i++) {
			var grow:Array = grid[i];
			var frow:Array = filled[i];
			for(var j=0; j < grow.length; j++) {
				if(grow[j]!=frow[j]) {
					return false;
				}
			}
		}
		return true;
	}
	
	function dropTrion(trion:trionclass, checkOverlaps:Boolean):Boolean {
		// check OK first
		trace("dropTrion");
		var row:Number = trion.row;
		var column:Number = trion.column;
		if(checkOverlaps == null) checkOverlaps = true;
		trace("trion.grid = " + trion.grid);
		if(checkOverlaps) {
			for(var i = 0; i < trion.grid.length; i++) {
				var trow:Array = trion.grid[i];
				trace("trion.row = " + trow);
				for(var j = 0; j < trow.length; j++) {
					if(trow[j]==1 && notAvailable(row+i,column+j)) {
						trace("square " +(row+i)+", "+(column+j)+" already occupied");
						pFilled();
						return false;
					}
				}
			}
		}
		// it's ok so do the drop
		for(var i = 0; i < trion.grid.length; i++) {
			var trow:Array = trion.grid[i];
			var frow:Array = filled[row+i];
			for(var j = 0; j < trow.length; j++) {
				if(trow[j]==1) {
					frow[column+j]++;
				}
			}
		}
		// mark trion as inside camel if it is
		trion.inCamel = completelyInsideCamel(trion);
		pFilled();
		return true;
	}
	
	function pickupTrion(trion:trionclass):Boolean {
		var row:Number = trion.row;
		var column:Number = trion.column;
		for(var i = 0; i < trion.grid.length; i++) {
			var trow:Array = trion.grid[i];
			for(var j = 0; j < trow.length; j++) {
				if(trow[j]==1) {
					filled[row+i][column+j]--;
				}
			}
		}
		trion.inCamel = false;
		return true;
	}

}