﻿
class Knot extends MovieClip {
	var onMove:Function;
	var thisObject:Object;
	public var x:Number;
	public var y:Number;
	var minx:Number=0;
	var miny:Number=0;
	var maxx:Number=550;
	var maxy:Number=400;
	var movable:Boolean = true;
	
	public function Knot() {
		x = _x;
		y = _y;
	}
	
	public function onRollOver():Void {
		if(movable) {
			gotoAndStop(2);
		}
	}
	
	public function onRollOut():Void {
		if(movable) {
			gotoAndStop(1);
		}
	}
	
	public function onPress():Void {
		if(movable) {
			gotoAndStop(3);
			onEnterFrame = checkForMove;
			this.startDrag(false, minx, miny, maxx, maxy);
		}
	}
	
	public function onRelease():Void {
		if(movable) {
			gotoAndStop(1);
			checkForMove();
			onEnterFrame = undefined;
			this.stopDrag();
		}
	}
	
	public function onReleaseOutside():Void {
		onRelease();
	}
	
	public function checkForMove() {
		if(_x != x || _y != y) {
			x = _x;
			y = _y;
			if(onMove != null && thisObject != null) {
				onMove.call(thisObject);
			}
		}
	}
}
	