﻿import Curve2;
import GraphHolder;
class Dropping extends MovieClip {
	var curve:Curve2;
	var graph:GraphHolder;
	var g:Number = 0.005;
	var iterationsPerFrame:Number = 20;
	var dt:Number = 1/iterationsPerFrame;
	var vx:Number = 0;
	var vy:Number = 0;
	var speed:Number = 0;
	var y0:Number;
	var yRelease:Number;
	var K0:Number = 0;
	var s:Number = 0; // position on curve
	var y:Number;

	function Dropping() {
		init();
	}
	
	function init() {
		_x = curve.x(0);
		y0 = curve.y(0);
		_y = y0;
		y = y0;
		yRelease = y0;
		s = 0;
		speed = 0;
	}
	
	function onPress() {
		graph.clearAll();
		_x = curve.x(0);
		y0 = curve.y(0);
		_y = y0;
		y = y0;
		yRelease = y0;
		s = 0;
		speed = 0;		
		if(_ymouse <= y0) {
			this.startDrag(true, _x, 0, _x, _y);
		}
	}
	
	function onRelease() {
		trace(dt);
		this.stopDrag();
		y = _y;
		yRelease = y;
		if(Math.abs(_root._ymouse - _y) < 5) {
			//onEnterFrame = drop;
			graph.timer();
		}
	}
	
	function onReleaseOutside() {
		//y = _y;
		onRelease(); //this.stopDrag();
	}
	
	function repeat():Void {
		this.stopDrag();
		speed = vy = 0;
		_y = yRelease;
		y = _y;
		s = curve.tGivenLocaly(yRelease, 0, 1);
		if(isNaN(s)) {
			s = 0;
		}
		_x = curve.x(s);
		//onEnterFrame = drop;
		graph.clearAll();
		graph.timer();
	}
	
	function speedAt(s:Number):Number {
		// 0 <= s <= 1. s is the parametric coordinate
		// Calculate speed on curve assuming no energy loss.
		// E0 is total energy density available at s=0
		// K0 is kinetic energy density at s=0
		var dK = g*(_y-yRelease);
		//var K = K0 + dK;
		return Math.sqrt(2*dK);
	}
	
	function slideIterate(dt:Number) {
		
		if(y < y0) {
			speed += g*dt;
			y += speed*dt;
			_y = y;
			vy = speed;
			//trace(" speed = "+speed + " vy=" + vy + " g = "+g);
			return;
		}
		
		var diffs:Object = curve.dxdyds(s);
		if(isNaN(diffs.ds)) {
			//onEnterFrame = undefined;
			graph.timer(); // stop graph
			time = null;
			vy = 0;
			return;
		}
		var a:Number = g*diffs.dy/diffs.ds;
		speed += a*dt; 
		vy = speed*diffs.dy/diffs.ds;
		y += vy*dt;
		_y = y;
		s = curve.tGivenLocaly(y, 0, 1);
		if(isNaN(s)) {
			//onEnterFrame = undefined;
			graph.timer() // stop graph
			time = null;
			vy = 0;
			return;
		}
		speed = speedAt(s);
		//trace(" speed = "+speed + " vy=" + vy + " a = "+a);
		_x = curve.x(s);
	}
	
	function iterate(dt:Number):Void {
		if(hitSomething()) {
		}
		else {
			// free drop
			vy += g*dt;
			_y += vy*dt;
		}
	}
	
	function hitSomething():Boolean {
		return _y < y0;
	}
	
	function curveParameter():Number {
		return Number.NaN;
	}
	
	var time:Number=null;
	function drop():Number {
		//trace("hi");
		if(time == null) {
			time = getTimer();
		}
		else {
			//var now = getTimer();
			//dt = (now - time) / iterationsPerFrame;
			//time = now;
			//for(var i = 0; i < iterationsPerFrame; i++) {
				slideIterate(dt);
				//onEnterFrame = undefined;
			//}
		}
		return vy;
	}
}