﻿import Knot;
class Curve2 extends MovieClip {

	public var knots:Array;
	public var epsilon_t:Number = 1/500000;
	
	public function Curve2() {
		knots = [];
		var minx:Number = 10;
		var miny:Number = 200;
		var maxx:Number = 540;
		var maxy:Number = 390;
		knots[0] = Knot(attachMovie("Knot", "k0", 1, {_x:minx, _y:miny, onMove:redraw, thisObject:this, movable:true, minx:minx, maxx:minx, miny:0, maxy:maxy}));
		knots[1] = Knot(attachMovie("Knot", "k1", 2, {_x:minx, _y:maxy, onMove:redraw, thisObject:this, movable:true, minx:minx, maxx:maxx, miny:miny, maxy:maxy}));
		knots[2] = Knot(attachMovie("Knot", "k2", 3, {_x:maxx, _y:maxy, onMove:redraw, thisObject:this, movable:true, minx:minx, maxx:maxx, miny:miny, maxy:maxy}));
		draw();
		//testInside();
	}
	
	public function draw():Void {
		//testParametric();
		lineStyle(3, 0x888888, 20);
		moveTo(knots[0].x, 0);
		lineTo(knots[0].x, knots[0].y);
		lineStyle(3, 0x008888, 100);
		curveTo(knots[1].x, knots[1].y, knots[2].x, knots[2].y);
	}
	
	public function redraw():Void {
		clear();
		draw();
		forceMonotonic();
	}
	
	public function forceMonotonic() {
		knots[0].maxx = knots[1].x;
		knots[0].maxy = knots[1].y;
		knots[1].minx = knots[0].x;
		knots[1].miny = knots[0].y;
		knots[1].maxx = knots[2].x;
		knots[1].maxy = knots[2].y;
		knots[2].minx = knots[1].x;
		knots[2].miny = knots[1].y;
	}
	
	public function x(t:Number):Number {
		var u = 1 - t;
		return knots[0].x*u*u + 2*knots[1].x*u*t + knots[2].x*t*t;
	}
	
	public function y(t:Number):Number {
		var u = 1 - t;
		return knots[0].y*u*u + 2*knots[1].y*u*t + knots[2].y*t*t;
	}
	
	public function dxdyds(t:Number):Object {
		var dx = 2*(-knots[0].x*(1-t) + knots[1].x*(1-2*t) + knots[2].x*t);
		var dy = 2*(-knots[0].y*(1-t) + knots[1].y*(1-2*t) + knots[2].y*t);
		return {dx:dx, dy:dy, ds:Math.sqrt(dx*dx+dy*dy)};
	}
	

	// This assumes x(t) is globally monotonic 
	public function t(xin:Number):Number {
		var t0:Number = 0;
		var t1:Number = 1;
		var interval:Object = {t0:0, t1:1};
		interval = inside(xin, interval);
		return interval.t0;
	}
	
	// This assumes x(t) is locally monotonic
	public function tLocal(xin:Number, t0:Number, t1:Number):Number {
		var interval:Object = {t0:t0, t1:t1};
		interval = inside(xin, interval);
		return interval.t0;
	}
	
	// This assumes y(t) is locally monotonic
	public function tGivenLocaly(yin:Number, t0:Number, t1:Number):Number {
		var interval:Object = {t0:t0, t1:t1};
		interval = yinside(yin, interval);
		return interval.t0;
	}
	
	//
	// TODO
	//
	public function tGivenXY(xin:Number, yin:Number, tin:Number) {
		var s = 1
	}
	
	private function yinside(yin:Number, interval:Object):Object {
		//trace("yin="+yin+ " t0="+interval.t0 + " t1="+interval.t1);
		var y0 = y(interval.t0);
		var y1 = y(interval.t1);
		var t = (interval.t1 + interval.t0)/2;
		if(Math.abs(interval.t1 - interval.t0) < epsilon_t) {
			return {t0:t, t1:t};
		}
		if(yin < y0 || yin > y1) {
			return {t0:Number.NaN, t1:Number.NaN};
		}
		var y2 = y(t);
		//trace("x2="+x2)
		if(yin <= y2) {
			return yinside(yin, {t0:interval.t0, t1:t});
		}
		return yinside(yin, {t0:t, t1:interval.t1});
	}
	
	
	private function inside(xin:Number, interval:Object):Object {
		//trace("xin="+xin+ " t0="+interval.t0 + " t1="+interval.t1);
		var x0 = x(interval.t0);
		var x1 = x(interval.t1);
		var t = (interval.t1 + interval.t0)/2;
		if(Math.abs(interval.t1 - interval.t0) < epsilon_t) {
			return {t0:t, t1:t};
		}
		if(xin < x0 || xin > x1) {
			return {t0:Number.NaN, t1:Number.NaN};
		}
		var x2 = x(t);
		//trace("x2="+x2)
		if(xin <= x2) {
			return inside(xin, {t0:interval.t0, t1:t});
		}
		return inside(xin, {t0:t, t1:interval.t1});
	}
	
	public function testParametric() {
		var count:Number = 25;
		var x0:Number;
		var y0:Number;
		var x1:Number;
		var y1:Number;
		lineStyle(5,0xFF0000, 30);
		for(var i:Number = 0; i < count; i++) {
			var t:Number = i/25;
			if(i == 0) {
				x0 = x(t);
				y0 = y(t);
				moveTo(x0, y0);
			}
			else {
				x1 = x(t);
				y1 = y(t);
				lineTo(x1, y1);
			}
		}
	}
	
	public function testInside() {
		for(var xin = 0; xin < 550; xin+=10) {
			//trace("xin="+xin+" t="+t(xin));
		}
	}
}
