﻿class Bezier extends MovieClip {
	var a:Object;
	var b:Object;
	var c:Object;
	var d:Object;
	var resolution:Number = 10;
	function bezier3(i:Number, t:Number):Object {
		var t2 = t*t;
		var t3 = t*t2;
		var u = 1-t;
		var u2 = u*u;
		var u3 = u*u2;
		var a:Object = as[i];
		var b:Object = bs[i];
		var c:Object = cs[i];
		var d:Object = ds[i];
		var x = t3*b._x+3*t2*u*d._x+3*t*u2*c._x+u3*a._x;
		var y = t3*b._y+3*t2*u*d._y+3*t*u2*c._y+u3*a._y;
		return {_x:x, _y:y};
	}
	function draw() {
		var point1:Object = bezier3(0);
		moveTo(point1._x, point1._y);
		for(var t = 1; t <= resolution; t++) {
			var point2:Object = bezier3(t/resolution);
			lineTo(point2._x, point2._y);
			point1._x = point2._x;
			point1._y = point2._y;
		}
	}
}