﻿
import mx.controls.NumericStepper;

class Polygon extends MovieClip {
	
	//The x and y position and length of the base line.
	private var base_x:Number = 50;
	private var base_y:Number = 150;
	private var base_length:Number = 400;
	
	//The radius of the circle in thich the polygon is inscribed.
	private var radius:Number = 50;
	
	//Number of sides of polygon.
	private var sides:Number = 5;
	
	//Angular rotation speed of polygons. Measured in radians per second.
	private var angVeloc:Number = 2;
	
	//How often setInterval is called.
	private var millisecs:Number = 10;
	
	//Interval ID of the timing device.
	private var intervalID:Number = 1000;
	
	//Consider left hand point of side of polygon touching the line. This
	//integer is number of sides along measured from the left.
	private var touch:Number = 0;
	
	//Start co-ordinates of polygon.
	private var start_x:Number = 0;
	private var start_y:Number = 0;
	
	//Co-ordiantes of the vertex about which we pivot. Its co-ordinates
	//relative to the poly movieclip.
	private var p_x:Number = 0;
	private var p_y:Number = 0;
	
	//Time since started rolling. In seconds.
	private var time:Number = 0;
	
	//Status of polygon.
	//0 = at start
	//1 = rolling
	//2 = at finish
	//3 = paused
	private var polyStatus:Number = 0;
	
	//Maximum number of sides.
	private var maxSides:Number = 12;
	
	//True iff curver plotter on.
	private var plotter:Boolean = true;
	
	//Co-ordinates of plotter point, relative to poly.
	private var plotter_x:Number = 0;
	private var plotter_y:Number = 0;
	
	//Distance travelled by plotter point.
	private var distance:Number = 0;
	
	//Snap to distance. (Square of distance.)
	private var snapToDistance:Number = 225;
	
	//For rewind/forward buttons.
	private var rollerID:Number = null;
	
	//Constructor.
	function Polygon() {
		init();
		
		buttonFunctionality();
	}
	
	//Initialisation of polygons.
	private function init():Void {
		
		this["greenSpot"].removeMovieClip();
		this["blueSpot"].removeMovieClip();
		
		this._parent.graphHolder.clearAll();
		
		//Numeric steppers are visible.
		this["side_stepper"].enabled = true;
		this["radius_stepper"].enabled = true;
		
		//Initialisation data.
		time = 0;
		touch = 0;
		distance = 0;
		polyStatus = 0; 
		plotter_x = 0;
		plotter_y = 0;
			 
		curveRegion();
		drawLine();
		drawPolygon();	
		attachSpot();	
		
		//Play button visible.
		this["play_btn"]._visible = true;
		this["pause_btn"]._visible = false;
		
	}
	
	//Draw the base line.
	private function drawLine():Void {
		this.createEmptyMovieClip("baseLine",this.getNextHighestDepth());
		this["baseLine"].lineStyle(2,0x000000,100);
		this["baseLine"].moveTo(base_x,base_y);
		this["baseLine"].lineTo(base_x+base_length,base_y);
	}
	
	//Draw the polygon.
	private function drawPolygon():Void {
		
		//Temporarily change sides to 100....
		//if (sides == maxSides) sides = 100;
		
		//Delete old poly.
		this["poly"].removeMovieClip();
		
		//Keep poly in a movie clip.
		this.createEmptyMovieClip("poly",this.getNextHighestDepth());
		
		//Angular separation of sides.
		var angle:Number = 2*Math.PI/sides;
		
		//Initial angle.
		var theta:Number = Math.PI/2-angle/2 ;
		
		//Set p_x and p_y.
		p_x = radius*Math.cos(theta);
		p_y = radius*Math.sin(theta);
		
		//Get in initial position.
		this["poly"].lineStyle(2,0x000000,100);
		this["poly"].beginFill(0xffffff,20);
		this["poly"].moveTo(p_x,p_y);
		
		//Draw sides.
		for (var i:Number = 0; i!= sides; i++) {
			theta += angle;
			this["poly"].lineTo(radius*Math.cos(theta),radius*Math.sin(theta));
		}
		this["poly"].endFill();
		
		//Put poly at edge of line.
		start_x = base_x+radius*Math.sin(angle/2);
		start_y = base_y-radius*Math.cos(angle/2);
		this["poly"]._x = start_x;
		this["poly"]._y = start_y;
		
		/*
		//Want poly to start moving when pressed.
		this["poly"].onPress = function():Void {
			if (this._parent.polyStatus == 0 || this._parent.polyStatus == 3) {
				this._parent.polyStatus = 1;
				this._parent.rollPoly();
			} else if (this._parent.polyStatus == 2) {
				this._parent.init();
			}
		}
		*/
		this["curveHolder"].moveTo(start_x+plotter_x,start_y+plotter_y);
		
	}
	
	//A movieclip to hold the curve that is drawn.
	private function curveRegion():Void {
		this["curveHolder"].removeMovieClip();
		this.createEmptyMovieClip("curveHolder",this.getNextHighestDepth());
		this["curveHolder"].lineStyle(1,0xcc0000,100);
		this["curveHolder"].moveTo(this["spot"]._x,this["spot"]._y);
	}
	
	private function attachSpot():Void {
		this["spot"].removeMovieClip();
		this.attachMovie("spot","spot",this.getNextHighestDepth(),{
		_x:start_x,_y:start_y });
		
		this["spot"].onPress = function() { 
		//Only pick up  if in initial position.
				var tp = this._parent;
				
				if ( tp.squareDist(tp["poly"]._x,tp["poly"]._y,tp.start_x,tp.start_y) < 10 )
				{
					if (this._parent.polyStatus == 0) this.startDrag();
				}
		}
		
		this["spot"].onRelease = function() {
			if (this._parent.polyStatus == 0) {
				//Let go of the thing.
				this.stopDrag();
				//Snap it if near a vertex, or centre, or mid-edge.
				this._parent.snapTo(this._x,this._y);
				//Reconsider where to draw line from.
				this._parent.curveRegion();
				
			}
		}
	}
	
	//Snap the spot to a particular point,
	//(a,b) the point that is dropped.
	private function snapTo(a:Number,b:Number):Void {
		
		//Problems with snapToDistance if lots of sides.
		if (sides > 8 && sides < 20) snapToDistance = snapToDistance/4; 
		
		//Default is to drop the thing anywhere.
		plotter_x = a-start_x;
		plotter_y = b-start_y;
		
		//If dropped near centre of poly, snap to centre.
		if ( squareDist(plotter_x,plotter_y,0,0) < snapToDistance) {
			plotter_x = plotter_y = 0;
		}
		
		//If dropped near vertex or centre of edge snap to.
		//Only do this if not too many sides.
		if (sides<70) {
		
			//Angular separation of sides.
			var angle:Number = 2*Math.PI/sides;
			//Distance of centre of side from centre of polygon.
			var polyDist:Number = radius*Math.cos(angle/2);
				
			for (var i:Number = 0; i != sides; i++) {
			
				var theta:Number = Math.PI/2-angle/2 +i*angle;
			
				var a:Number = radius*Math.cos(theta);
				var b:Number = radius*Math.sin(theta);
			
				//Vertices.
				if ( squareDist(plotter_x,plotter_y,a,b) < snapToDistance) {
					plotter_x = a;
					plotter_y = b;
					break;
				}
				
				
				var a:Number = polyDist*Math.cos(theta+angle/2);
				var b:Number = polyDist*Math.sin(theta+angle/2);
			
				//Sides.
				if ( squareDist(plotter_x,plotter_y,a,b) < snapToDistance) {
					plotter_x = a;
					plotter_y = b;
					break;
				}
			}
		} else {
			//This is the circle case.
			var c:Number = squareDist(plotter_x,plotter_y,0,0);
			var d:Number = Math.sqrt(snapToDistance);
			if ( c < (radius+d)*(radius+d) && c > (radius-d)*(radius-d) ) {
				var e:Number = Math.sqrt(c);
				plotter_x = plotter_x * radius/e;
				plotter_y = plotter_y * radius/e;
			}
		}
		
		//If spot is miles away, send it back to the middle.
		if (squareDist(plotter_x,plotter_y,0,0) > (radius+30)*(radius+30)) 
			plotter_x = plotter_y = 0;
		
		//Snap in position.
		this["spot"]._x = start_x+plotter_x;
		this["spot"]._y = start_y+plotter_y;
		
		if (sides > 8 && sides < 20) snapToDistance = 4*snapToDistance;
	}
	
	//Square of separation of (a,b) and (c,d).
	private function squareDist(a:Number,b:Number,c:Number,d:Number) {
		return (a-c)*(a-c)+(b-d)*(b-d);
	}
	
	//Roll the polygon.
	private function rollPoly():Void {
		
		//Disable controls.
		this["side_stepper"].enabled = false;
		this["radius_stepper"].enabled = false;
		
		trace("p = "+polyStatus);
		if (polyStatus == 0) {
		
		//Bring in green and blue spots.
		this.attachMovie("greenSpot","greenSpot",this.getNextHighestDepth(), {
		_x: this["spot"]._x,_y:base_y,_alpha:70																   
		});
		this.attachMovie("blueSpot","blueSpot",this.getNextHighestDepth(),{
		_x: base_x, _y:this["spot"]._y,_alpha:70																   
		});																
		
		}
								
		polyStatus = 1;						
	
		//Bad coding this, but I can't be bothered to sort out 
		//the 'correct' thing.
		if (!this._parent.graphHolder.timerOn) this._parent.graphHolder.timer(); 
		
		if (intervalID != null) {
					//trace("clearInterval");
					clearInterval(intervalID);
		 }
		 
		//Call counter() every millisecs milliseconds. 
		trace("polyIDbefore = "+intervalID);
		intervalID = setInterval(this,"counter",millisecs);
		trace("polyIDafter = "+intervalID);
		updateAfterEvent();
		
		trace("poly rolling");
	}
	
	//Move the polygon along.
	private function counter():Void {
		//trace("poly interval");
		time += millisecs/1000;
		
		var temp1:Number = time*angVeloc;
		var temp2:Number = Math.PI/sides;
		var temp3:Number = 2*temp2;
		
		//Number of touches.
		touch = Math.floor( temp1/temp3 );
		//Left over angle of rotation.
		var rot:Number = temp1 - touch*temp3;
		
		//Rotate poly.
		this["poly"]._rotation = rot*180/Math.PI;
		
		//Now position the polygon appropriately.
		this["poly"]._x = start_x + p_x - Math.cos(rot)*p_x + Math.sin(rot)*p_y;
		this["poly"]._y = start_y + p_y - Math.sin(rot)*p_x - Math.cos(rot)*p_y;
		
		//Move along by touch spots
		this["poly"]._x += 2*touch*radius*Math.sin(temp2);
		
		//Plot a line segment.
		if (plotter) {
			var global_x:Number = this["poly"]._x + Math.cos(temp1)*plotter_x - Math.sin(temp1)*plotter_y;
			var global_y:Number = this["poly"]._y + Math.sin(temp1)*plotter_x + Math.cos(temp1)*plotter_y;
			distance += Math.sqrt( (this["spot"]._x-global_x)*(this["spot"]._x-global_x) + 
								   (this["spot"]._y-global_y)*(this["spot"]._y-global_y) );
			this["spot"]._x = global_x;
			this["spot"]._y = global_y;
			
			this["greenSpot"]._x = global_x;
			this["blueSpot"]._y = global_y;
			
			this["curveHolder"].lineTo(global_x,global_y);
		}
		
		
		//Stop rolling when reach end of the line.
		if ( (this["poly"]._x > base_x + base_length - 2*p_x) && (rot < 0.1 )) {
			clearInterval(intervalID);
			this._parent.graphHolder.stopper();
			polyStatus = 2;
			this["play_btn"]._visible = false;
			this["pause_btn"]._visible = false;
		}
	}
	
	//Get distance measurement.
	private function getDistance():Number {
		return distance;
	}
	
	//Operation of the button.
	private function buttonFunctionality():Void {
		
		this["rewind_btn"].onPress = function() {
			if (this._parent.polyStatus != 1) this._parent.roller(false);
		}
		this["rewind_btn"].onRelease = function() {
			if (this._parent.polyStatus != 1) {
				clearInterval(this._parent.rollerID);
				 if (this._parent.polyStatus == 0) this._parent.curveRegion();
			}
		}
		this["rewind_btn"].onReleaseOutside = function() {
			if (this._parent.polyStatus != 1) {
				clearInterval(this._parent.rollerID);
				if (this._parent.polyStatus == 0) this._parent.curveRegion();
			}
		}
		
		this["forward_btn"].onPress = function() {
			if (this._parent.polyStatus != 1) this._parent.roller(true);
		}
		this["forward_btn"].onRelease = function() {
			if (this._parent.polyStatus != 1) {
				clearInterval(this._parent.rollerID);
				if (this._parent.polyStatus == 0) this._parent.curveRegion();
			}
		}
		this["forward_btn"].onReleaseOutside = function() {
			if (this._parent.polyStatus != 1) {
				clearInterval(this._parent.rollerID);
				if (this._parent.polyStatus == 0) this._parent.curveRegion();
			}
		}
		
		this["pause_btn"].onPress = function() {
			if (this._parent.polyStatus == 1) {
				this._parent["pause_btn"]._visible = false;
				this._parent["play_btn"]._visible = true;
				clearInterval(this._parent.intervalID);
				this._parent._parent.graphHolder.timer();
				this._parent.polyStatus = 3;
			}
		}
		
		this["play_btn"].onPress = function() {
			if (this._parent.polyStatus == 0 || this._parent.polyStatus == 3) {
				this._parent["curveHolder"].moveTo(this._parent["spot"]._x,this._parent["spot"]._y);
				this._parent["pause_btn"]._visible = true;
				this._parent["play_btn"]._visible = false;
				//this._parent.polyStatus = 1;
				this._parent.rollPoly();
				this.startDrag();
			}
		}
		
		this["clear_btn"].onPress = function() {
			clearInterval(this._parent.intervalID);
			
			//Just in case code:
			for (var i:Number = 0; i!=5000; i++)
				clearInterval(i);
			
			this._parent._parent.graphHolder.stopper();
			this._parent.init();
		}
		
	}
	
	//Roll the polygon.
	private function roller(forward:Boolean):Void {
		
		if (rollerID != null) clearInterval(intervalID);
		 
		//Call roll() every millisecs milliseconds. 
		rollerID = setInterval(this,"roll",millisecs,forward);
		updateAfterEvent();
	}
	
	private function roll(forward:Boolean):Void {
		
		//Only roll if on line.
		if ( (this["poly"]._x < base_x + base_length && forward) ||
		     (this["poly"]._x > base_x) && !forward) {
		
			if (forward)  time+= millisecs/1000; else time-= millisecs/1000; 
		
			var temp1:Number = time*angVeloc;
			var temp2:Number = Math.PI/sides;
			var temp3:Number = 2*temp2;
		
			//Number of touches.
			touch = Math.floor( temp1/temp3 );
			//Left over angle of rotation.
			var rot:Number = temp1 - touch*temp3;
		
			//Rotate poly.
			this["poly"]._rotation = rot*180/Math.PI;
		
			//Now position the polygon appropriately.
			this["poly"]._x = start_x + p_x - Math.cos(rot)*p_x + Math.sin(rot)*p_y;
			this["poly"]._y = start_y + p_y - Math.sin(rot)*p_x - Math.cos(rot)*p_y;
		
			//Move along by touch spots
			this["poly"]._x += 2*touch*radius*Math.sin(temp2);
			
			this["spot"]._x = this["poly"]._x + Math.cos(temp1)*plotter_x - Math.sin(temp1)*plotter_y;
			this["spot"]._y = this["poly"]._y + Math.sin(temp1)*plotter_x + Math.cos(temp1)*plotter_y;
			
			this["greenSpot"]._x = this["spot"]._x;
			this["blueSpot"]._y = this["spot"]._y;
		}
	}
	
	public function horizontalDistance():Number {
		return this["spot"]._x - base_x;
	}
	public function verticalDistance():Number {
		return base_y - this["spot"]._y;
	}
	
}