﻿//Pretty sure I can delete next three paragraphs.

/* One of the biggest difficulties with the functionality of the graph is 
setting scales so that correct section of graph gets plotted. I have 
decided that the region that is displayed should be specified with each 
instance of Graph. Then if I try to plot a line that leaves this area, I 
implement such that those parts that leave the area do not get plotted.

If I am to plot a 'scrolling' graph, then I make the instance of Graph very 
wide (only some it will be displayed in the ScrollPane at any one time).*/

/*Need event handler: start timing. Every time plotSegment is called, 
a line segment is drawn from previous point to current point.*/

class Graph extends MovieClip{
	
	//See GraphHolder.as for purpose of below variables. Put all in a list.
	public var xUnit:Number;
	public var yUnitDist:Number;
	public var yUnitVeloc:Number;
	public var yUnitAccel:Number;
	public var xLow:Number;
	public var xHigh:Number;
	public var yLowDist:Number;
	public var yLowVeloc:Number;
	public var yLowAccel:Number;
	public var yHighDist:Number;
	public var yHighVeloc:Number;
	public var yHighAccel:Number;
	public var ticks:Boolean;
	public var markers:Boolean;
	public var grid:Boolean;
	public var xTickGap:Number;
	public var yTickGapDist:Number;
	public var yTickGapVeloc:Number;
	public var yTickGapAccel:Number;
	public var curveAlpha:Number;
	public var curveThickness:Number;
	public var distCol:Number;
	public var velocCol:Number;
	public var accelCol:Number;	
	public var axesLabels:Number;
	public var xAxisLabel:String;
	public var yAxisLabelDist:String;
	public var yAxisLabelVel:String;
	public var yAxisLabelAccel:String;
	
	//These variables get Graph in right place.
	public var xOrigin:Number=0; //xUnit*xLow; 
	public var yOrigin:Number=0;//yUnit*yLow;
	
	function Graph() {
		//Must attend to this depending on which curve is selected.
		this._x= -xUnit*xLow+20;
		this._y= yUnitDist*yHighDist+20;
		init();
	}
	
	function init():Void {
		
		//Background colour.
		
		drawAxes();
		//Draw ticks. Numbered iff markers == true. Grid iff grid==true.
		if (ticks) drawTicks();
		if (axesLabels) drawAxesLabels();
		
		//Mcs into which curves can be drawn.
		this.createEmptyMovieClip("curveDist",getNextHighestDepth());
		this.createEmptyMovieClip("curveVeloc",getNextHighestDepth());
		this.createEmptyMovieClip("curveAccel",getNextHighestDepth());
		
		//Initially velocity and accelelation are invisible.
		this["curveVeloc"]._visible = false;
		this["curveAccel"]._visible = false;
		this["axesVeloc"]._visible = false;
		this["axesAccel"]._visible = false;
		trace("here is data:");
		trace(this["curveVeloc"]);
		trace(this["curveAccel"]);
		trace(this["axesVeloc"]);
		trace(this["axesAccel"]);
	}

	
	//Draw the initial axes.
	private function drawAxes():Void {
		//Distance axes.
		createEmptyMovieClip("axesDist",getNextHighestDepth());
		this["axesDist"].lineStyle(1,distCol,30);
		this["axesDist"].moveTo(xOrigin,-yLowDist*yUnitDist);
		this["axesDist"].lineTo(xOrigin,-yHighDist*yUnitDist);
		this["axesDist"].moveTo(xLow*xUnit,yOrigin);
		this["axesDist"].lineTo(xHigh*xUnit,yOrigin);
		
		//Velocity axes.
		createEmptyMovieClip("axesVeloc",getNextHighestDepth());
		this["axesVeloc"].lineStyle(1,velocCol,30);
		this["axesVeloc"].moveTo(xOrigin,-yLowVeloc*yUnitVeloc);
		this["axesVeloc"].lineTo(xOrigin,-yHighVeloc*yUnitVeloc);
		this["axesVeloc"].moveTo(xLow*xUnit,yOrigin);
		this["axesVeloc"].lineTo(xHigh*xUnit,yOrigin);
		
		//Acceleration axes.
		createEmptyMovieClip("axesAccel",getNextHighestDepth());
		this["axesAccel"].lineStyle(1,accelCol,30);
		this["axesAccel"].moveTo(xOrigin,-yLowAccel*yUnitAccel);
		this["axesAccel"].lineTo(xOrigin,-yHighAccel*yUnitAccel);
		this["axesAccel"].moveTo(xLow*xUnit,yOrigin);
		this["axesAccel"].lineTo(xHigh*xUnit,yOrigin);
	}
	
	//Draw little ticks equally spaced along axes, possibly numbered.
	private function drawTicks():Void {
		
		//Distance ticks.
		var space:Number = xLow;//-xTickGap;
		while (space <= xHigh) {
			//space += xTickGap;
			this["axesDist"].moveTo(space*xUnit,yOrigin+3);
			this["axesDist"].lineTo(space*xUnit,yOrigin-3);
			//Draw grid line iff grid==true;
			if (grid) {//trace("in loop");
				this["axesDist"].lineStyle(1,distCol,10);
				this["axesDist"].moveTo(space*xUnit,-yLowDist*yUnitDist);
				this["axesDist"].lineTo(space*xUnit,-yHighDist*yUnitDist);
				this["axesDist"].lineStyle(1,distCol,30);
			}
			//Number the ticks only if markers is set to true.
			if (markers) {
				this["axesDist"].createTextField("digx"+space,this["axesDist"].getNextHighestDepth(),space*xUnit-5,yOrigin-2,20,20);
				this["axesDist"]["digx"+space].align = "centre";
				this["axesDist"]["digx"+space].text = space;
				this["axesDist"]["digx"+space].selectable = false;
			}
			space += xTickGap;
		}
		space = -yLowDist;//+yTickGapDist;
		while (space >= -yHighDist) {
			//space -= yTickGapDist;
			this["axesDist"].moveTo(xOrigin+3,space*yUnitDist);
			this["axesDist"].lineTo(xOrigin-3,space*yUnitDist);
			if (grid) {
				this["axesDist"].lineStyle(1,distCol,10);
				this["axesDist"].moveTo(xLow*xUnit,space*yUnitDist);
				this["axesDist"].lineTo(xHigh*xUnit,space*yUnitDist);
				this["axesDist"].lineStyle(1,distCol,30);
			}
			if (markers) {
				this["axesDist"].createTextField("digy"+space,this["axesDist"].getNextHighestDepth(),xOrigin-15,space*yUnitDist-8,20,20);
				var sp:Number = -space;
				this["axesDist"]["digy"+space].text = sp;
				this["axesDist"]["digy"+space].bold = true;
				this["axesDist"]["digy"+space].selectable = false;
			}
			space -= yTickGapDist;
		}
		
		//Velocity ticks.
		var space:Number = xLow;//-xTickGap;
		while (space <= xHigh) {
			//space += xTickGap;
			this["axesVeloc"].moveTo(space*xUnit,yOrigin+3);
			this["axesVeloc"].lineTo(space*xUnit,yOrigin-3);
			//Draw grid line iff grid==true;
			if (grid) {//trace("in loop");
				this["axesVeloc"].lineStyle(1,velocCol,10);
				this["axesVeloc"].moveTo(space*xUnit,-yLowVeloc*yUnitVeloc);
				this["axesVeloc"].lineTo(space*xUnit,-yHighVeloc*yUnitVeloc);
				this["axesVeloc"].lineStyle(1,velocCol,30);
			}
			//Number the ticks only if markers is set to true.
			if (markers) {
				this["axesVeloc"].createTextField("digx"+space,this["axesVeloc"].getNextHighestDepth(),space*xUnit-5,yOrigin-2,20,20);
				this["axesVeloc"]["digx"+space].align = "centre";
				this["axesVeloc"]["digx"+space].text = space;
				this["axesVeloc"]["digx"+space].selectable = false;
			}
			space += xTickGap;
		}
		space = -yLowVeloc;//+yTickGapVeloc;
		while (space >= -yHighVeloc) {
			//space -= yTickGapVeloc;
			this["axesVeloc"].moveTo(xOrigin+3,space*yUnitVeloc);
			this["axesVeloc"].lineTo(xOrigin-3,space*yUnitVeloc);
			if (grid) {
				this["axesVeloc"].lineStyle(1,velocCol,10);
				this["axesVeloc"].moveTo(xLow*xUnit,space*yUnitVeloc);
				this["axesVeloc"].lineTo(xHigh*xUnit,space*yUnitVeloc);
				this["axesVeloc"].lineStyle(1,velocCol,30);
			}
			if (markers) {
				this["axesVeloc"].createTextField("digy"+space,this["axesVeloc"].getNextHighestDepth(),xOrigin-15,space*yUnitVeloc-8,20,20);
				var sp:Number = -space;
				this["axesVeloc"]["digy"+space].text = sp;
				this["axesVeloc"]["digy"+space].selectable = false;
			}
			space -= yTickGapVeloc;
		}
		
		//Acceleration ticks.
		var space:Number = xLow;//-xTickGap;
		while (space <= xHigh) {
			//space += xTickGap;
			this["axesAccel"].moveTo(space*xUnit,yOrigin+3);
			this["axesAccel"].lineTo(space*xUnit,yOrigin-3);
			//Draw grid line iff grid==true;
			if (grid) {//trace("in loop");
				this["axesAccel"].lineStyle(1,accelCol,10);
				this["axesAccel"].moveTo(space*xUnit,-yLowAccel*yUnitAccel);
				this["axesAccel"].lineTo(space*xUnit,-yHighAccel*yUnitAccel);
				this["axesAccel"].lineStyle(1,accelCol,30);
			}
			//Number the ticks only if markers is set to true.
			if (markers) {
				this["axesAccel"].createTextField("digx"+space,this["axesAccel"].getNextHighestDepth(),space*xUnit-5,yOrigin-2,20,20);
				this["axesAccel"]["digx"+space].align = "centre";
				this["axesAccel"]["digx"+space].text = space;
				this["axesAccel"]["digx"+space].selectable = false;
			}
			space += xTickGap;
		}
		space = -yLowAccel;//+yTickGapAccel;
		while (space >= -yHighAccel) {
			//space -= yTickGapAccel;
			this["axesAccel"].moveTo(xOrigin+3,space*yUnitAccel);
			this["axesAccel"].lineTo(xOrigin-3,space*yUnitAccel);
			if (grid) {
				this["axesAccel"].lineStyle(1,accelCol,10);
				this["axesAccel"].moveTo(xLow*xUnit,space*yUnitAccel);
				this["axesAccel"].lineTo(xHigh*xUnit,space*yUnitAccel);
				this["axesAccel"].lineStyle(1,accelCol,30);
			}
			if (markers) {
				this["axesAccel"].createTextField("digy"+space,this["axesAccel"].getNextHighestDepth(),xOrigin-15,space*yUnitAccel-8,20,20);
				var sp:Number = -space;
				this["axesAccel"]["digy"+space].text = sp;
				this["axesAccel"]["digy"+space].selectable = false;
			}
			space -= yTickGapAccel;
		}
		
	}
	
	private function drawAxesLabels():Void {
		this["axesDist"].createTextField("yLabelDist",this["axesDist"].getNextHighestDepth(),xOrigin-5,-yUnitDist*yHighDist-20,80,20);
		this["axesDist"]["yLabelDist"].html = true;
		this["axesDist"]["yLabelDist"].htmlText = "<font face =\"_sans\" ><b>distance</b></font>";//yAxisLabelDist;
		this["axesDist"]["yLabelDist"].selectable = false;
		
		this["axesDist"].createTextField("xLabelDist",this["axesDist"].getNextHighestDepth(),xUnit*xHigh+5,yOrigin-10,80,20);
		this["axesDist"]["xLabelDist"].html = true;
		this["axesDist"]["xLabelDist"].htmlText = "<font face =\"_sans\" ><b>time</b></font>";
		this["axesDist"]["xLabelDist"].selectable = false;
		
		this["axesVeloc"].createTextField("yLabelVeloc",this["axesVeloc"].getNextHighestDepth(),xOrigin-5,-yUnitVeloc*yHighVeloc-20,80,20);
		this["axesVeloc"]["yLabelVeloc"].text = yAxisLabelVel;
		this["axesVeloc"]["yLabelVeloc"].selectable = false;
		this["axesVeloc"].createTextField("xLabelVeloc",this["axesVeloc"].getNextHighestDepth(),xUnit*xHigh+5,yOrigin-10,80,20);
		this["axesVeloc"]["xLabelVeloc"].text = xAxisLabel;
		this["axesVeloc"]["xLabelVeloc"].selectable = false;

		this["axesAccel"].createTextField("yLabelAccel",this["axesAccel"].getNextHighestDepth(),xOrigin-5,-yUnitAccel*yHighAccel-20,80,20);
		this["axesAccel"]["yLabelAccel"].text = yAxisLabelAccel;
		this["axesAccel"]["yLabelAccel"].selectable = false;
		this["axesAccel"].createTextField("xLabelAccel",this["axesAccel"].getNextHighestDepth(),xUnit*xHigh+5,yOrigin-10,80,20);
		this["axesAccel"]["xLabelAccel"].text = xAxisLabel;
		this["axesAccel"]["xLabelAccel"].selectable = false;

	}
	
	//Plots a segment from (xStart,yStart) to (xFinish,yFinish).
	//typeOfCurve is distance:0,velocity:1,speed:2,acceleration:3.
	public function plotSegment(typeOfCurve,xStart,yStart,xFinish,yFinish,colour:Number):Void {
		//trace("the colour is "+colour);
		switch(typeOfCurve) {
			case 0:
				this["curveDist"].lineStyle( curveThickness, colour,curveAlpha);
				this["curveDist"].moveTo(xStart*xUnit,-yStart*yUnitDist);
				this["curveDist"].lineTo(xFinish*xUnit,-yFinish*yUnitDist);	
				//trace("how many times in here0");
				break;
			case 1:
				this["curveVeloc"].lineStyle( curveThickness, colour,curveAlpha);
				this["curveVeloc"].moveTo(xStart*xUnit,-yStart*yUnitVeloc);
				this["curveVeloc"].lineTo(xFinish*xUnit,-yFinish*yUnitVeloc);	
				//trace("how many times in here1");
				break;
			case 3:
				this["curveVeloc"].lineStyle( curveThickness, colour,curveAlpha);
				this["curveVeloc"].moveTo(xStart*xUnit,-yStart*yUnitVeloc);
				this["curveVeloc"].lineTo(xFinish*xUnit,-yFinish*yUnitVeloc);
				//trace("how many times in here3");
				break;
			case 2:
				this["curveAccel"].lineStyle( curveThickness, colour,curveAlpha);
				this["curveAccel"].moveTo(xStart*xUnit,-yStart*yUnitAccel);
				this["curveAccel"].lineTo(xFinish*xUnit,-yFinish*yUnitAccel);	
				//trace("how many times in here2");
				break;
		}
	}
		
		
		
	/*
	
	//Plots the whole line.
	public function plotLine(line:LineIcon):Void {
		trace("In graph.plotLine");
		//Only plot those points that occur in the graph area.
		this.lineStyle(2,line.lineColour,100);
		var inPos:Boolean = false;
		for (var i:Number=0; i!=line.points.length; i++) {
			if (line.points[i][0]>=xLow && line.points[i][0]<=xHigh
			&& line.points[i][1]>=yLow && line.points[i][1]<=yHigh){
				if (!inPos) { 
					this.moveTo(xOrigin+xIncr*line.points[i][0],yOrigin-yIncr*line.points[i][1]); 
					inPos=true;
				}
				this.lineTo(xOrigin+xIncr*line.points[i][0],yOrigin-yIncr*line.points[i][1]);
			}
		}
		
	}
	
	*/
	
}