﻿/* This is a repository for the information regarding a 
particular curve. As the curve is generated, we calculate 
in real time the distance, velocity and acceleration. This
amounts to three arrays per Curve instance, the arrays being 
populated in real time.*/

class Curve {
	
	//These are data to be plotted, each of dist/veloc/accel against time. 
	public var times:Array;
	public var dist:Array;
	public var veloc:Array;
	public var accel:Array;
	
	//Colours of the curves. Defaults are red/blue/green resp.
	public var distCol:Number = 10027008;
	public var velocCol:Number = 3355545;
	public var accelCol:Number = 39168;
	
	//These variables are true iff we are to show the relevant graph.
	public var showDist:Boolean = true;
	public var showSpeed:Boolean = true;
	public var showVeloc:Boolean = true;
	public var showAccel:Boolean = true;

	function Curve() {
		times = new Array();
		dist = new Array();
		veloc = new Array();
		accel = new Array();
	}

	
}