﻿import Cog;
import mx.controls.NumericStepper;

class Cogs extends MovieClip {
	
	private var coggers:Array;
	
	private var cogCount:Number = 0;
	
	//The crushing arm.
	private var crusher:MovieClip;
	
	function Cogs() {
		
		//The cogs are stored in a coggers array.
		coggers = new Array();
		
		//Add crusher at very high depth above everything.
		crusher = attachMovie("crusher","crusher",5000,{_x:400,_y:20});

		//Initial cog.
		addCog(6);
		init();
	}
	
	private function init() {
		
		//Initialise buttons. Buttons added in at last minute so I just pasted code from elsewhere.
		
		this["leftTwist"].onPress = function() {
			function here(cog:Cog,d:Boolean) { cog._parent.rotator(cog,d); }
			for (var i:Number = 0; i!=this._parent.coggers.length; i++)  
				if (this._parent.coggers[i].chosen) 
					var intervalID:Number = setInterval(here,15,this._parent.coggers[i],false);
		}
		this["leftTwist"].onRelease = function() {
			for (var i:Number = 0; i!=5000; i++) clearInterval(i);
		}
		this["rightTwist"].onPress = function() {
			function here(cog:Cog,d:Boolean) { cog._parent.rotator(cog,d); }
			for (var i:Number = 0; i!=this._parent.coggers.length; i++)  
				if (this._parent.coggers[i].chosen) 
					var intervalID:Number = setInterval(here,15,this._parent.coggers[i],true);
		}
		this["rightTwist"].onRelease = function() {
			for (var i:Number = 0; i!=5000; i++) clearInterval(i);
		}
		this["controler"].onPress = function() {
			for (var i:Number = 0; i!=this._parent.coggers.length; i++)  
				if (this._parent.coggers[i].chosen) {
					var newCog = this._parent.coggers[i];
					newCog.spot.angle += Math.PI/newCog.teeth;
					var k:Number = Math.abs(  ((newCog.spot.angle) % (2*Math.PI)) - (2*Math.PI)/(6*newCog.teeth) );
					if ( k<0.01 ) 
						newCog.spot._visible = false;
					else {
						if (!newCog.spot._visible) {
							newCog.spot._visible = true;
							newCog.spot.angle -= Math.PI/newCog.teeth;
						}
						if (!newCog.spot.out) {
							//trace("in");
							newCog.spot._x = Math.cos( newCog.spot.angle )*newCog.innerRadius*3/4;
							newCog.spot._y = Math.sin( newCog.spot.angle )*newCog.innerRadius*3/4;
						} else {
							//trace("out");
							newCog.spot._x = Math.cos( newCog.spot.angle )*newCog.outerRadius*3/4;
							newCog.spot._y = Math.sin( newCog.spot.angle )*newCog.outerRadius*3/4;
						}
						newCog.spot.out =(newCog.spot.out) ? false : true;
					}
				}
		}
				
	}
	
	
	
	public function simpleDeleteCog(cog:Cog) {
		
		//Find index of cog to be deleted.
		var index:Number = -1;
		for (var i:Number = 0; i!=coggers.length; i++) {
			//trace("coggers["+i+"] = "+coggers[i]);
			//trace("cog = "+cog);
			if (coggers[i] == cog) index = i;
		}
		
		coggers[index].removeMovieClip();
		coggers.splice(index,1);
	}
		
	public function deleteCog(cog:Cog){
		
		//Find index of cog to be deleted.
		var index:Number = -1;
		for (var i:Number = 0; i!=coggers.length; i++) {
			//trace("coggers["+i+"] = "+coggers[i]);
			//trace("cog = "+cog);
			if (coggers[i] == cog) index = i;
		}
		//trace(this["crusher"]);
		this["crusher"].gotoAndPlay(1);
		coggers[index]._x = 460;
		coggers[index]._y = 360-coggers[index].outerRadius;
		
		var intervalID = setInterval(squash,10);
		var mc = coggers[index];
		var mv = this;
		var count:Number=0;
		
		 function squash() {
			if (count>32-mc.teeth) {
				mc._y += mc._height*0.05;
				mc._height = mc._height * 0.9;
			}
			if (count == 42-mc.teeth) {
				//trace("made it to 20 and mc is "+mc);
				//trace("and parent is "+mc._parent);
				mc.removeMovieClip();
				//trace("index is "+index);
				mv.coggers.splice(index,1);
				clearInterval(intervalID);
			}
			count++;
		}
		
		
	}
	
	
	//Add a new cog function.
	public function addCog(teeth:Number) {
		//Not using getNextHighestDepth as I want crusher to appear above cogs.
		var newCog = Cog(attachMovie("Cog","cog"+cogCount,5+cogCount,
		{identifier:cogCount,teeth:teeth,_x:460,_y:100}));
		coggers.push(newCog);
		cogCount++;
		
		//Dragging controls.
		newCog.onPress = function() {
			
			//If in initial position, need to replace with another cog.
			if (this.inInitialPosition) {
				this._parent.addCog(this._parent.num_stepper.value);
				this.inInitialPosition = false;
				this._parent.messages.play();
			}
			
			//Change this cog so that it is the chosen one.
			for (var i:Number = 0; i!=this._parent.coggers.length; i++) 
				if (this._parent.coggers[i] != this) {
					this._parent.coggers[i].chosen = false;
					this._parent.coggers[i]._alpha = 50;
				}
			this.chosen = true;
			this._alpha = 100;
			this.startDrag();
			
		}
		
		//Dropping controls.
		newCog.onRelease = function() {
			
			//Firstly, delete it if it hits the bin. Only if crusher not in motion
			if ( this.hitTest(this._parent["bin"]) && !this._parent.crusher.inMotion ) {
				this._parent.deleteCog(this);
				this.stopDrag();
				
			
			//Only allowed to drop cog if within region. 	
			} else if (   (this._x - this.outerRadius > 10) && (this._x + this.outerRadius < 390)
					  &&  (this._y - this.outerRadius > 10) && (this._y + this.outerRadius < 390)  ) {
				
				//Are they interlocked?
				var hit:Boolean = false;
				for (var i:Number = 0; i!=this._parent.coggers.length; i++) {
					if( (this._parent.coggers[i] != this) && (this._parent.interlock(this,this._parent.coggers[i])<2.5) )
						{hit = true;}
						//trace("coggers "+i);
				}
	
				if (!hit) this.stopDrag();
			}
			
		}
		
		//Rotate the cog (or turn spot on or off).
		var oUserKey:Object = new Object();
		oUserKey.onKeyDown = function():Void {
			var nKey:Number = Key.getCode();
			if (nKey == Key.LEFT && newCog.chosen) {
				newCog._parent.rotator(newCog,false);
			}
			if (nKey == Key.RIGHT && newCog.chosen) {
				newCog._parent.rotator(newCog,true);
			}
			if (nKey == Key.CONTROL && newCog.chosen) {
				newCog.spot.angle += Math.PI/newCog.teeth;
				var k:Number = Math.abs(  ((newCog.spot.angle) % (2*Math.PI)) - (2*Math.PI)/(6*newCog.teeth) );
				//trace("angle = "+k);
				if ( k<0.01 ) 
					newCog.spot._visible = false;
				else {
					if (!newCog.spot._visible) {
						newCog.spot._visible = true;
						newCog.spot.angle -= Math.PI/newCog.teeth;
					}
					if (!newCog.spot.out) {
						//trace("in");
						newCog.spot._x = Math.cos( newCog.spot.angle )*newCog.innerRadius*3/4;
						newCog.spot._y = Math.sin( newCog.spot.angle )*newCog.innerRadius*3/4;
					} else {
						//trace("out");
						newCog.spot._x = Math.cos( newCog.spot.angle )*newCog.outerRadius*3/4;
						newCog.spot._y = Math.sin( newCog.spot.angle )*newCog.outerRadius*3/4;
					}
					newCog.spot.out =(newCog.spot.out) ? false : true;
				}
				
			}
		}
		Key.addListener(oUserKey);
	}
	
	//Determines whether can rotate cog and whether it turns other cogs. 
	private function rotator(cog:Cog,clockwise:Boolean):Void {
		trace("In rotator.");
		//trace("cog is "+cog);
		//trace("boolean is "+clockwise);
		
		//Must go through every cog and assign it either 0 if not to be related
		//and -1 if rotate anticlockwise and 1 if rotate clockwise. If at any stage
		//something gets assigned both -1 and 1 then nothing gets rotated.
		
		//Here is an array of 0,-1 and 1s then.
		var instructions:Array = new Array(coggers.length);
		for (var i:Number = 0; i!= instructions.length; i++) 
			if (coggers[i]==cog) instructions[i] = (clockwise) ? 1 : -1;
			else instructions[i]=0;
		
	
		//Keep iterating next loop until no new cogs detected.
		var newLoops:Boolean = true;
		
		while (newLoops) {
			
			//Set newLoops to false originally.
			newLoops = false;
			
			//Consider every cog.
			for (var i:Number = 0; i!=instructions.length; i++) {
				//Consider movement only of those cogs that are affected.
				if (instructions[i] != 0) {
					//Look at all those adjacent cogs.
					for (var j:Number = 0; j!=instructions.length; j++) {
						//Only look at adjacent cogs.
						if (coggers[j] != coggers[i] && simpleInterlock(coggers[i],coggers[j]) == 3) {
							//Change 0 to 1 or -1 if necessary.
							if (instructions[j]==0) {newLoops = true; instructions[j]=-instructions[i];}
							//If contradictory rotations then error.
							else if (instructions[j]==instructions[i]) return;
						}
					}
					
				}
				
			}
			
			
			
		}
		
		//Now perform the rotation.
		for (var i:Number = 0; i!=instructions.length; i++) {
			if (instructions[i] != 0) coggers[i]._rotation += 10*instructions[i]/coggers[i].teeth;
			
		}
		
		
	}
	
	private function simpleInterlock(cog1:Cog,cog2:Cog):Number {
		
		//Separation squared.
		var sepSq:Number = (cog1._x-cog2._x)*(cog1._x-cog2._x)+(cog1._y-cog2._y)*(cog1._y-cog2._y);
				
		if ( sepSq > (cog1.outerRadius+cog2.outerRadius)*(cog1.outerRadius+cog2.outerRadius) ) 
		 return 4;
		
		
		else if ( sepSq > (cog1.innerRadius+cog2.innerRadius)*(cog1.innerRadius+cog2.innerRadius) ) 
		return 3;
		
		else return 1;
	}
	
	//Tests interlocking of this with other cog.
	//Returns 1 if intersect.
	//Returns 2 if intersect and overlap.
	//Returns 3 if intersect and not overlap.
	//Returns 4 if totally separate.
	private function interlock(cog1:Cog,cog2:Cog):Number {
		
		//Separation squared.
		var sepSq:Number = (cog1._x-cog2._x)*(cog1._x-cog2._x)+(cog1._y-cog2._y)*(cog1._y-cog2._y);
				
		if ( sepSq > (cog1.outerRadius+cog2.outerRadius)*(cog1.outerRadius+cog2.outerRadius) ) 
		 return 4;
		
		
		else if ( sepSq > (cog1.innerRadius+cog2.innerRadius)*(cog1.innerRadius+cog2.innerRadius) ) {
		 	//return 3; 
		 
		 	//Following paragraph written at later date: What I should have done rather than all
			//the crap below is to do loads of hitTests on points around outside of cog. 
		 
		 
		 	//New experimental code now to determine if the teeth of adjacent cogs are on top of each 
			 //other. 
		
		 	//By default, the centre of the teeth occur at  (5/6+n)*(2*Math.PI/teeth) for integers n. 
		 	//Suppose one disc at (0,0) and other at (T,0).
		 	//So if disc1_rotation = - (5/6+n)*(2*Math.PI/teeth) for some n then disc1 tooth pointing at disc2.
		 	//So if disc2_rotation = pi- (5/6+n)*(2*Math.PI/teeth) for some n then disc2 tooth pointing at disc2.
		
			//First work out angle between (x2,y2) to (x1,y1) line and horizontal.
			var angle:Number = -Math.atan2(cog2._y-cog1._y,cog2._x-cog1._x);
			//trace("angle is = "+ angle);
			
			//Is cog1 tooth pointing at cog2? error1 measures the error in this.
			var temp1:Number = 2*Math.PI/cog1.teeth;
			
			
			var error1:Number = difference(angle,temp1,-cog1._rotation*Math.PI/180+temp1*5/6); 
			var t = -cog1._rotation*Math.PI/180+temp1*5/6;
			//trace("first tooth at angle = "+t);
			//trace("angular divide ="+temp1);
			
			//trace("error1 is = "+error1);
			
			var temp2:Number = 2*Math.PI/cog2.teeth;
			var error2:Number = difference(angle+Math.PI,temp2,-cog2._rotation*Math.PI/180+temp2*5/6); 
			//trace("error2 is = "+error2);
			
		
			//If both error1 and error2 are small then teeth are pointing at each other.
			//Errors run between roughly 0 and 0.5.
			var errorMargin:Number = 0.2; 
			//if (Math.abs(error1-error2)
			if (error1+error2<0.3 || error1+error2>0.6) return 2; //Definite overlap.
			else return 3;
		
		
			 //End of experimental code.
		}
		
		else return 1;
		
	}
	
	//Finds minimum of |a-(nb+c)| for integers n.
	private function difference(a:Number,b:Number,c:Number):Number {
		var n:Number = 100;
		var twoPi:Number = Math.PI*2;
		for (var i:Number = 0; i!= 20; i++) {
			var k =  ((a-i*b-c) + 50*twoPi) % (twoPi); //trace(k);
			k = Math.min(k,twoPi-k);
			if (k<n) n=k;
		}
		//trace("going to return "+n);
		return n;
	}
	
}

