﻿

class Cog extends MovieClip{
	
	public var teeth:Number = 10;
	
	//Is this cog highlighted?
	public var chosen:Boolean = false;
	
	//This needed to determine when cog leaves initial position, so that new cog
	//can be put there. 
	public var inInitialPosition = true;
	
	public var identifier:Number;
	
	public var spot:MovieClip;
	
	//Radius dependent on number of teeth.
	public var innerRadius:Number = 35;
	public var outerRadius:Number = 50;
	// not sure need this: public var rotationUnit:Number = 1;
	
	function Cog() {
		
		innerRadius = Math.floor(3.5*teeth);
		outerRadius = 5*teeth;
		
		trace("outerRadius="+outerRadius);
		init();
	}
	
	private function init():Void {
		
		//Draw the cog.
		this.clear();
		this.lineStyle(1,0x6688AA,0); 
		this.beginFill(0xcc0000,100);
		this.drawGear(0,0, teeth, innerRadius, outerRadius,0);
		this.endFill();
		
		//Now add a handy spot for counting number of cog rotations.
		spot = attachMovie("spot","spot",getNextHighestDepth());
		spot.angle = (2*Math.PI)/(6*teeth);
		spot.out = true; //Outside first.
		spot._x = Math.cos( spot.angle )*outerRadius*3/4;
		spot._y = Math.sin( spot.angle )*outerRadius*3/4;
		//spot._x = Math.cos( (2*Math.PI)/(6*teeth) )*outerRadius*3/4;
		//spot._y = Math.sin( (2*Math.PI)/(6*teeth) )*outerRadius*3/4;
		spot._visible = false;
	}
	
	//Note on how to make cogs that fit together.
	//The only important variables for this below are sides, innerRadius and outerRadius.
	//The gap between teeth is approx (3/4)*outerRadius*(2pi)/sides. So roughly just 
	//need to make the quantities outerRadius /sides all the same.
	
	//When sides=10, innerRadius = 35 and outerRadius = 50 produces a good cog so we want to preserve these
	//ratios. i.e. outerRadius/sides = 5 and innerRadius/sides = 3.5;
	//This is reflected in the drawGear command above.
	//To produce better fitting cogs, I could modify the code below so that the 'sloping' bit
	//of each cog is smaller. At the moment the cog is drawn via a repetitive procedure that
	//draws the cog outline in a number of angle theta sections, where theta/4 angle is used
	//for each sloping bit on a tooth, and theta/4 for the inner and outer lines. (So just
	//decrease some of these theta/4 for the sloping bits.
	
	//I'm going to try 1/6s
	
	
	//Draw cog code.
	private function drawGear(x, y, sides, innerRadius, outerRadius, angle, holeSides, holeRadius) {
		// ==============
		// mc.drawGear() - by Ric Ewing (ric@formequalsfunction.com) - version 1.3 - 3.5.2002
		// 
		// x, y = center of gear.
		// sides = number of teeth on gear. (must be > 2)
		// innerRadius = radius of the indent of the teeth.
		// outerRadius = outer radius of the teeth.
		// angle = [optional] starting angle in degrees. Defaults to 0.
		// holeSides = [optional] draw a polygonal hole with this many sides (must be > 2)
		// holeRadius = [optional] size of hole. Default = innerRadius/3.
		// ==============
		if(arguments<5) {
			return;
		}
		if (sides>2) {
			// init vars
			var step, qtrStep, start, n, dx, dy;
			// calculate length of sides
			step = (Math.PI*2)/sides;
			//qtrStep = step/4; Ian replaced this with
			qtrStep = step/6;
			// calculate starting angle in radians
			start = (angle/180)*Math.PI;
			this.moveTo(x+(Math.cos(start)*outerRadius), y-(Math.sin(start)*outerRadius));
			// draw lines
			for (n=1; n<=sides; n++) {
				dx = x+Math.cos(start+(step*n)-(qtrStep*5))*innerRadius;
				dy = y-Math.sin(start+(step*n)-(qtrStep*5))*innerRadius;
				this.lineTo(dx, dy);
				dx = x+Math.cos(start+(step*n)-(qtrStep*3))*innerRadius;
				dy = y-Math.sin(start+(step*n)-(qtrStep*3))*innerRadius;
				this.lineTo(dx, dy);
				dx = x+Math.cos(start+(step*n)-qtrStep*2)*outerRadius;
				dy = y-Math.sin(start+(step*n)-qtrStep*2)*outerRadius;
				this.lineTo(dx, dy);
				dx = x+Math.cos(start+(step*n))*outerRadius;
				dy = y-Math.sin(start+(step*n))*outerRadius;
				this.lineTo(dx, dy);
			}
			// This is complete overkill... but I had it done already. :)
			if (holeSides>2) {
				if(holeRadius == undefined) {
					holeRadius = innerRadius/3;
				}
				step = (Math.PI*2)/holeSides;
				this.moveTo(x+(Math.cos(start)*holeRadius), y-(Math.sin(start)*holeRadius));
				for (n=1; n<=holeSides; n++) {
					dx = x+Math.cos(start+(step*n))*holeRadius;
					dy = y-Math.sin(start+(step*n))*holeRadius;
					this.lineTo(dx, dy);
				}
			}
		}
	}
	
	
	
	
	
}