﻿/**
*
* Someday, I'll rewrite this - it's a mess. Mike
*
* @class it.sephiroth.XML2Object
* @author Alessandro Crugnola
* @version 1.0
* @description return an object with the content of the XML translated
* NOTE: a node name with "-" will be replaced with "_" for flash compatibility.
* for example  will become FIRST_NAME
* If a node has more than 1 child with the same name, an array is created with the children contents
* The object created will have this structure:


* 	- obj {

*		nodeName : {

*			attributes : an object containing the node attributes

*			data : an object containing the node contents

*	}

* @usage data = new XML2Object().parseXML( anXML);
*/
//import utils.string

class XML2Object extends XML {
	private var oResult:Object = new Object ();
	private var oXML:XML;
	/**
	* @method get xml
	* @description return the xml passed in the parseXML method
	* @usage theXML = XML2Object.xml
	*/
	public function get xml():XML {
		return oXML
	}
	/**
	* @method public parseXML
	* @description return the parsed Object
	* @usage XML2Object.parseXML( theXMLtoParse );
	* @param sFile XML
	* @returns an Object with the contents of the passed XML
	*/
	public function parseXML (sFile:XML):Object {
		this.oResult = new Object ();
		this.oXML = sFile;
		this.oResult = this.translateXML();
		return compress(this.oResult);
	}
	private function compress (obj:Object):Object {
		if(obj.toString().indexOf("[object") != 0) {
			return obj;
		}
		if(obj.sequence) {
			obj.sequence = undefined;
			for(var child in obj) {
				if(obj[child].length > 1) {
					//trace("Array: [" + child +"] length=" + obj[child].length);
					return compress(obj[child]);
				}
				else {
					var o:Object = compress(obj[child]);
					return o == null ? null : [o];
				}
			}
			return null;
		}
		else {
			// Make sure we return an array rather than an object if we possibly can
			var copy:Object;
			if(obj instanceof Array) {
				copy = [];
			}
			else {
				copy = {};
			}
			for(var child in obj) {
				//trace("child is array " + (child instanceof Array));
				var o:Object = compress(obj[child]);
				if(o != null) {
					copy[child]=o;
				}
			}
			return copy;
		}
	}
	/**
	* @method private translateXML
	* @description core of the XML2Object class
	*/
	private function translateXML (from, path, name, position) {
		var xmlName:String;
		//trace("name="+name+" position="+position);
		var nodes, node, old_path;
		if (path == undefined) {
			path = this;
			name = "oResult";
		}
		path = path[name];
		if (from == undefined) {
			from = xml;
			from.ignoreWhite = true;
		}
		if (from.hasChildNodes ()) {
			nodes = from.childNodes;
			if (position != undefined) {
				var old_path = path;
				path = path[position];
			}
			while (nodes.length > 0) {
				node = nodes.shift ();
				xmlName = node.nodeName.split("-").join("_");
				//trace("xmlName="+xmlName);
				if (xmlName != undefined) {
					var __obj__ = new Object ();
					//__obj__.attributes = node.attributes;
					for(var attr in node.attributes) {
						var a = node.attributes[attr];
						if(a == "true") {
							a = true;
						}
						else if(a == "false") {
							a = false;
						}
						else if(!isNaN(Number(a))) {
							a = Number(a);
						}
						__obj__[attr] = a;
					}
					var d:String = node.firstChild.nodeValue;
					if(d != null) {
						__obj__.data = stripEntities(d); 
					}
					if (position != undefined) {
						var old_path = path;
					}
					if (path[xmlName] != undefined) {
						if (path[xmlName].__proto__ == Array.prototype) {
							path[xmlName].push (__obj__);
							name = node.nodeName;
							position = path[xmlName].length - 1;
						} else {
							var copyObj = path[xmlName];
							path[xmlName] = new Array ();
							path[xmlName].push (copyObj);
							path[xmlName].push (__obj__);
							name = xmlName;
							position = path[xmlName].length - 1;
						}
					} else {
						path[xmlName] = __obj__;
						name = xmlName;
						position = undefined;
					}
				}
				if (node.hasChildNodes ()) {
					this.translateXML (node, path, name, position);
				}
			}
		}
		return this.oResult;
	}
	/////////////////////////////////////////////////
	// 
	// Utility function to replace XML entities with their text equivalents
	// &lt; -> <
	// &gt; -> >
	// &apos; -> '
	// &quot; -> "
	// &amp; -> &
	//
	// Needed since XMLSpy/Authentic inserts them (Grrr! - but I suppose it
	// means we don't run the risk of badly formed XML)
	//
	static function stripEntities(msg_str:String):String {
		var i = 0;
		var j = 0;
		var s = "";
		if (msg_str == null || msg_str == undefined) {
			return s;
		}
		while ((j = msg_str.indexOf("&", i)) >= 0) {
			//trace("i="+i+" j="+j);
			s += msg_str.substring(i, j);
			i = msg_str.indexOf(";", j + 1);
			if (i < 0) {
				// lone '&' - not an entity
				return s + msg_str.substring(j);
			}
			var entity = msg_str.substring(j + 1, i++);
			switch (entity) {
			case 'lt' :
				s += '<';
				break;
			case 'gt' :
				s += '<';
				break;
			case 'apos' :
				s += '<';
				break;
			case 'quot' :
				s += '<';
				break;
			case 'amp' :
				s += '<';
				break;
			default :
				//Logger.log(Logger.ERROR, "unrecognised entity: &"+ entity +";");
				s += entity;
			}
		}
		s += msg_str.substring(i);
		return s;
	}

}

