﻿import Lamina;
import Spring;
import Vector;
class Pivot extends MovieClip {
	var free:Boolean = false;
	var lamina:Lamina;
	var spring:Spring;
	function Pivot() {
		if(free) {
			onRelease = onReleaseOutside = doRelease;
			onPress = doPress;
		}
		//tabEnabled = true;
		//focusEnabled = true;
		//hitArea = this["hole"];
	}
	function get globalXY():Vector {
		//var p:Object = {x:(_x+_width/2), y:(_y+_height/2)};
		var p:Object = {x:_x, y:_y};
		_parent.localToGlobal(p);
		return new Vector(p);
	}
	function onRollOver() {
		//var r:Vector = _parent.centreOfGravity.minus(globalXY);
		if(spring != null) {
			_root.tt.tooltipText = spring.tooltipText();
			_root.tt.tooltipShow = true;
		}
		else {
			lamina.tooltip(true);
		}
	}
	function onRollOut() {
		_root.tt.tooltipShow = false;
	}
	function doPress() {
		_global.frozen = true;
		this.startDrag(true);
	}
	function doRelease() {
		//trace("DO RELEASE");
		_global.frozen = false;
		_parent.thaw();
		this.stopDrag();
		//_parent.recalibrate();
		//trace(Lamina.instances.length);
		var drop:MovieClip = null;
		for(var i:Number = 0; i < Lamina.instances.length; i++) {
			var lam:Lamina = Lamina(Lamina.instances[i]);
			if(lam.hooks == null || lam.hooks.length == 0 || lam.continuous) {
				drop = lam.image;
				if(drop.hitTest(_root._xmouse, _root._ymouse, true)) {
					trace("HIT1");
					if(lam == _parent) {
						// TODO: snap to parent slot here
						lam.thaw();
						return;
					}
					else {
						var p:Pivot = clone(lam);
						this.removeMe();
						lam.addPivot(p);
						return;
					}
				}
			}
			else {
				var tolerance = 8;
				for(var k:Number = 0; k < lam.hooks.length; k++) {
					var hook:Hook = Hook(lam.hookClips[k]);
					var dx = lam._xmouse - hook._x;
					var dy = lam._ymouse - hook._y;
					if((dx*dx+dy*dy) < tolerance*tolerance) {
					//if(Math.abs(lam._xmouse - hook._x) < tolerance && Math.abs(lam._ymouse - hook._y) < tolerance) {
						trace("HIT2");
						if(lam == _parent) {
							_x = hook._x;
							_y = hook._y;
							lam.thaw();
							return;
						}
						else {
							var p:Pivot = clone(lam);
							p._x = hook._x;
							p._y = hook._y;
							this.removeMe();
							lam.addPivot(p);
							return;
						}		
					}
				}
			}
		}
		unhookMe();
		/*
		var q:Pivot = clone(_root); 
		this.removeMe();
		*/
	}
	function attachMe(lam:Lamina, hook:Hook):Void {
		var p:Pivot = clone(lam);
		p._x = hook._x;
		p._y = hook._y;
		this.removeMe();
		lam.addPivot(p);
	}
	function unhookMe():Void {
		clone(_root); // TODO: replace with ref to main? 
		removeMe();
	}
	function removeMe() {
		//trace("PIVOT removeMe() called");
		var lam:Lamina = Lamina(_parent);
		lam.removePivot(this);
		this.removeMovieClip();
	}
	function clone(parent:MovieClip):Pivot {
		var depth:Number = parent.getNextHighestDepth();
		var p:Object = globalXY;
		parent.globalToLocal(p);
		var pivot:Pivot = Pivot(parent.attachMovie("Ring", "pivot"+depth, depth, {_x:p.x/*-_width/2*/, _y:p.y/*-_height/2*/, free:free, spring:spring}));
		spring.hole = pivot;
		return pivot;
	}
	/*
	function kick() {
		//trace("kick");
		onEnterFrame = draw;
	}
	*/
	/*
	function draw() {
		if(lamina != null)
		{
			var g:Vector = globalXY;
			var h:Vector = lamina.globalXY(lamina.holePosition);
			//lamina._x += (g.x-h.x);
			//lamina._y += (g.y-h.y);
			lamina.nudgeTo(g.x-h.x+lamina._x, g.y-h.y+lamina._y);
		}
	}
	*/
}