﻿//import ps.logging.Logger;
import XML2Object;
class Config extends XML {
	public var loaded:Boolean = false;
	public var stageW:Number = 550;
	public var stageH:Number = 400;
	private var _callback:Function = null;
	private var _thisObject:Object = null;
	private var _data:Object;
	//
	// dynamics
	//
	/*
	public var gravity:Number = 10;
	public var viscosity:Number = 0.8;
	public var k:Number = 2;
	public var defaultModulus = 0.2;
	public var fulcra:Array;
	public var laminas:Array;
	*/
	public function get gravity():Number {
		return _data.gravity;
	}
	public function set gravity(n:Number):Void {
		_data.gravity = n;
	}
	public function get viscosity():Number {
		return _data.viscosity;
	}
	public function set viscosity(n:Number):Void {
		_data.viscosity = n;
	}
	public function get k():Number {
		return _data.k;
	}
	public function set k(n:Number):Void {
		_data.k = n;
	}
	public function get defaultModulus():Number {
		return _data.defaultModulus;
	}
	public function set defaultModulus(n:Number):Void {
		_data.defaultModulus = n;
	}
	public function get backdrop():String {
		return (_data.backdrop == null) ? "Level12" :_data.backdrop;
	}
	public function get stands():Array {
		return _data.stands;
	}
	public function set stands(a:Array):Void {
		_data.stands = a;
	}
	public function get laminas():Array {
		return _data.laminas;
	}
	public function set laminas(a:Array):Void {
		_data.laminas = a;
	}
	public function get springs():Array {
		var s:Array = _data.springs;
		if(s.ttWeight == null) s.ttWeight = true;
		if(s.ttMass == null) s.ttMass = false;
		if(s.ttTension == null) s.ttTension = false;
		if(s.ttLength == null) s.ttLength = false;
		if(s.ttRestLen == null) s.ttRestLen = false;
		if(s.ttModulus == null) s.ttModulus = false;
		return s;
	}
	public function get table():Object {
		return _data.table;
	}
	//
	static var easePoints:Array = [0, -0.0002, 0.0003, 0.0013, 0.003, 0.0054, 0.0083, 0.012, 0.0163, 0.0212, 0.0269, 0.0333, 0.0404, 0.0482, 0.0567, 0.0661, 0.0761, 0.087, 0.0987, 0.1111, 0.1244, 0.1385, 0.1543, 0.1722, 0.1929, 0.2169, 0.2454, 0.28, 0.324, 0.385, 0.5, 0.6016, 0.6633, 0.7087, 0.7446, 0.7742, 0.799, 0.8202, 0.8383, 0.8542, 0.8691, 0.8829, 0.8958, 0.9078, 0.9189, 0.9291, 0.9386, 0.9472, 0.9551, 0.9623, 0.9688, 0.9746, 0.9798, 0.9843, 0.9882, 0.9916, 0.9943, 0.9965, 0.9982, 0.9994];
	//
	var messages:Array;
	//
	//
	function Config() {
		super();
		ignoreWhite = true;
		//init();
	}
	function load(url:String, callback:Function, thisObject:Object) {
		_callback = callback;
		_thisObject = thisObject;
		super.load(url);
	}
	function onLoad(success:Boolean):Void {
		if (!success) {
			trace("config load error(" + status + ")");
			_data = {};
			return;
		}
		var xmlo:XML2Object = new XML2Object();
		_data = xmlo.parseXML(this).balancer;
		//
		// Callback to final configuration
		//
		if (_thisObject != null) {
			_callback.call(_thisObject, this);
		}
		else {
			_callback(this);
		}
		return;
	}
	/*
	//  
	// Parse top level element
	//
	var _xml:XMLNode = this.firstChild;
	var i:Number;
	var s:String;
	var b:Boolean;
	//
	i = Number(_xml.attributes["gravity"]);
	if (i != null && !isNaN(i) && i > 0) {
	gravity = i;
	//trace("gravity=" + gravity);
	}
	//  
	i = Number(_xml.attributes["viscosity"]);
	if (i != null && !isNaN(i) && i > 0) {
	viscosity = i;
	//trace("viscosity=" + viscosity);
	}
	//  
	i = Number(_xml.attributes["k"]);
	if (i != null && !isNaN(i) && i > 0) {
	k = i;
	trace("k=" + k);
	}
	//  
	i = Number(_xml.attributes["defaultModulus"]);
	if (i != null && !isNaN(i) && i > 0) {
	defaultModulus = i;
	//trace("defaultModulus=" + defaultModulus);
	}
	//  
	// trashVisible = (_xml.attributes["trashVisible"] == "true");
	//
	for (var n = _xml.firstChild; n; n = n.nextSibling) {
	//trace(n.nodeName);
	switch (n.nodeName) {
	case 'fulcra' :
	for(var m = n.firstChild; m; m = m.nextSibling) {
	var f:Object = {};
	f.idname = m.attributes['idname'];
	f.movable = validBoolean(m.attributes['movable'], true);
	f.deletable = validBoolean(m.attributes['deletable'], false);
	f.x = validPosint(m.attributes["x"], 0);
	f.y = validPosint(m.attributes["y"], 0);
	//trace(f.idname + " " +(f.movable ? "movable,":"")+(f.deletable? " deletable,":"")+" fulcrum@("+f.x+", "+f.y+")");
	fulcra.push(f);
	}
	break;
	case 'laminas' :
	for(var m = n.firstChild; m; m = m.nextSibling) {
	var lamina:Object = {};
	lamina.idname = m.attributes['idname'];
	//lamina.clonable = validBoolean(m.attributes['clonable'], true);
	//lamina.deletable = validBoolean(m.attributes['deletable'], false);
	lamina.x = validPosint(m.attributes["x"], 0);
	lamina.y = validPosint(m.attributes["y"], 0);
	//trace("lamina= "+lamina.idname+"@("+lamina.x+", "+lamina.y+")");
	var holes:XMLNode = m.firstChild;
	if(holes != null) {
	lamina.holes = [];
	for(var h:XMLNode = holes.firstChild; h; h = h.nextSibling) {
	h.idname = m.attributes['idname'];
	h.x = validPosint(m.attributes["x"], 0);
	h.y = validPosint(m.attributes["y"], 0);
	trace("hole= "+h.idname+"@("+h.x+", "+h.y+")");
	lamina.holes.push(h);
	}
	}
	laminas.push(lamina);
	}
	break;
	case 'messages' :
	//Parse list of messages
	for (var m = n.firstChild; m; m = m.nextSibling) {
	var s = "message[" + (m.attributes["name"]) + "]";
	s += m.firstChild.nodeValue;
	//trace(s);
	// create an array of messages with the same name
	var name:String = m.attributes["name"];
	if (messages[name] == null) {
	messages[name] = [];
	}
	messages[name].push({text:stripEntities(m.firstChild.nodeValue)});
	messages[name].x = 0;
	}
	break;
	}
	}
	//
	// Callback to final configuration
	//
	_callback.call(_thisObject, this);
	}
	*/
	////
	// Ensure positive integer - defaulting to zero
	//
	function validPosint(o:Object):Number {
		var n:Number = Number(o);
		if (n == null || isNaN(n) || n < 0) {
			return 0;
		}
		return Math.round(n);
	}
	////
	// Ensure integer - defaulting to zero
	//
	function validInt(o:Object):Number {
		var n:Number = Number(o);
		if (n == null || isNaN(n)) {
			return 0;
		}
		return Math.round(n);
	}
	////
	// Ensure boolean with default T/F
	//
	function validBoolean(o:Object, def:Boolean):Boolean {
		if (def) {
			return o != "false";
		}
		else {
			return o == "true";
		}
	}
	/////////////////////////////////////////////////
	// 
	// Utility function to replace XML entities with their text equivalents
	// &lt; -> <
	// &gt; -> >
	// &apos; -> '
	// &quot; -> "
	// &amp; -> &
	//
	// Needed since XMLSpy/Authentic inserts them (Grrr! - but I suppose it
	// means we don't run the risk of badly formed XML)
	//
	static function stripEntities(msg_str:String):String {
		var i = 0;
		var j = 0;
		var s = "";
		if (msg_str == null || msg_str == undefined) {
			return s;
		}
		while ((j = msg_str.indexOf("&", i)) >= 0) {
			//trace("i="+i+" j="+j);
			s += msg_str.substring(i, j);
			i = msg_str.indexOf(";", j + 1);
			if (i < 0) {
				// lone '&' - not an entity
				return s + msg_str.substring(j);
			}
			var entity = msg_str.substring(j + 1, i++);
			switch (entity) {
			case 'lt' :
				s += '<';
				break;
			case 'gt' :
				s += '<';
				break;
			case 'apos' :
				s += '<';
				break;
			case 'quot' :
				s += '<';
				break;
			case 'amp' :
				s += '<';
				break;
			default :
				//Logger.log(Logger.ERROR, "unrecognised entity: &"+ entity +";");
				s += entity;
			}
		}
		s += msg_str.substring(i);
		return s;
	}
	//
	// Messages with the same name are stored in an array. We cycle
	// through these messages as getMessageObject is called.
	//
	public function getMessageObject(name:String):Object {
		var n:Array = messages[name];
		var rv:Object = n[n.x++];
		if (n.x >= n.length) {
			n.x = 0;
			n.nomore = true;
		}
		return rv;
	}
	public function getText(msg:Object):String {
		return msg.text;
	}
	static function ease(t, b, c, d) {
		if (d == 0) {
			t = 1;
		}
		else {
			t = t / d;
			if (t < 0) {
				t = 0;
			}
			if (t > 1) {
				t = 1;
			}
		}
		return b + c * easePoints[Math.floor(t * (easePoints.length - 1))];
	}
}
