﻿import WeightIcon;
class BaseWeight extends MovieClip implements WeightIcon {
	var idname:String;
	var _masses:Array;
	var _centreOfGravity:Object = null;
	function BaseWeight() {
	}
	public function draw(w:Number):Void {
		_centreOfGravity = null;
		//trace("drawing " + w + "weights");
		for(var i = 0; i < w; i++) {
			var _mc = attachMovie(idname, "w"+i, i);
			var xy:Object = getWeightXY(i, _mc);
			_mc._x = xy._x;
			_mc._y = xy._y;
			if(_masses == null) {
				_masses = [];
			}
			_masses.push(_mc);
		}
	}
	public function clear():Void {
		super.clear();
		for(var i = 0; i < _masses.length; i++) {
			var _mc:MovieClip = MovieClip(_masses[i]);
			_mc.removeMovieClip();
		}
	}
	public function getWeightXY(w:Number, clip_mc:MovieClip):Object {
		// Calculate the centre of the wth weight to be drawn
		var x:Number;
		var y:Number;
		return {_x:0, _y:(w)*clip_mc._height};
	}
	public function getCentreOfGravity():Object {
		if(_centreOfGravity == null) {
			var mx:Number = 0;
			var my:Number = 0;
			for(var i = 0; i < _masses.length; i++) {
				var _mc = MovieClip(_masses[i]);
				mx += (_mc._x + _mc._width/2);
				my += (_mc._y + _mc._height/2);
			}
			_centreOfGravity = {_x:(mx/_masses.length), _y:(my/_masses.length)}
		}
		return _centreOfGravity;
	}
}