﻿class Vector {
	var x:Number = 0;
	var y:Number = 0;
	function Vector(p:Object) {
		x = p.x;
		y = p.y;
	}
	function length():Number {
		return Math.sqrt(x*x+y*y);
	}
	function plus(v:Vector):Vector {
		return new Vector({x:(x+v.x), y:(y+v.y)});
	}
	function minus(v:Vector):Vector {
		return new Vector({x:(x-v.x), y:(y-v.y)});
	}
	function negate():Vector {
		return new Vector({x:-x, y:-y});
	}
	function times(s:Number):Vector {
		return new Vector({x:s*x, y:s*y});
	}
	function dot(v:Vector):Number {
		return x*v.x + y*v.y;
	}
	function crozz(v:Vector):Number {
		return (v.x*y - v.y*x);
	}
	function hasValue():Boolean {
		return !(isNaN(x) || isNaN(y));
	}
	function rotate(theta:Number):Vector {
		return new Vector({x:x*Math.cos(theta),y:Math.sin(theta)});
	}
	function toString():String {
		return "("+x+","+y+")";
	}
}