﻿import Main;
import Config;
import Hook;
import Vector;
import Protractor;
class Stand extends MovieClip {
	var iConfig: Object;
	var hook:Hook;
	var spot:MovieClip;
	var ml:MovieClip;
	var colorTransform:Color;
	var greyTransform:Object;
	var nullTransform:Object;
	var holeDepth:Number = 100;
	function Stand() {
	 	_x = x;
		_y = y;
		// create colour transforms
		// hook = this["hook"];
		//trace("stand hook = " + hook); 
		colorTransform = new Color(this);
		nullTransform = colorTransform.getTransform();
		greyTransform = {ra:0, rb:0, ga:0, gc:0, ba:0, bb:0, aa:30, ab:0};
		//trace("spot = " + spot._x+","+spot._y);
		hook = Hook(attachMovie("Fulcrum","hook", 1, {_x:spot._x, _y:spot._y}));
		if(hook != null) {
			hook.stand = this;
			if(attachment != null) {
				attachLamina(attachment.laminaId, attachment.holeId, attachment.position);
			}
		}
		checkAttachment();
		if(protractor != null) {
			attachMovie(protractor, "protractor", 50);
		}
		//drop();
	}
	//
	// instance configuration
	//
	function get idname():String {
		return iConfig.idname;
	}
	function get movable():Boolean {
		return iConfig.movable == null ? "true" : iConfig.movable;
	}
	function get deletable():Boolean {
		return iConfig.deletable == null ? "false" : iConfig.deletable;
	}
	function get attachment():Object {
		return iConfig.attachment;
	}
	function set attachment(obj:Object):Void {
		iConfig.attachment = obj;
	}
	function get protractor():String {
		if(iConfig.protractor != "" && iConfig.protractor != "") {
			return iConfig.protractor;
		}
	}
	function get x():Number {
		return iConfig.x;
	}
	function get y():Number {
		return iConfig.y;
	}
	function set x(n:Number):Void {
		iConfig.x = n;
	}
	function set y(n:Number):Void {
		iConfig.y = n;
	}
	//
	// Absolute position
	//
	function globalXY(v:Vector):Vector {
		var p:Object = {x:v.x,y:v.y}
		localToGlobal(p);
		return new Vector(p);
	}
	//
	// Capture screen to XML
	//
	function toXML():String {
		//<stand idname="Stand1" movable="true" deletable="false" x="100" y="100">
		//	<attachment laminaId="bar" holeId="h1" position="0.5"/>
		//</stand>
		var s = '<stand idname="'+idname+'" movable="'+movable+'" deletable="'+deletable+'" x="'+_x+'" y="'+_y+'"';
		if(attachment != null) {
			
			s += ">\n\t<attachment "+'laminaId="'+attachment.laminaId+'" holeId="'+attachment.holeId+'"';
			if(attachment.position != null) {
				s += ' position="'+attachment.position+'"'
			}
			s += "/>\n"+'</stand>';
		}
		else {
			s += "/>";
		}
		return s;
	}
	//
	//
	//
	function attachLamina(lamId:String, holeId:String, position:Number):Void {
		var lamina:Lamina = _parent.getLaminaById(lamId);
		//trace("attaching to "+ lamina.id+" hook="+hook);
		lamina.holeOnHook(hook, holeId, position);
	}
	function checkAttachment():Boolean {
		//trace("hook.laminaState = "+hook.laminaState().length);
		if(hook != null && hook.laminaState().length > 0) {
			colorTransform.setTransform(nullTransform);
			return true;
		}
		colorTransform.setTransform(greyTransform);	
		return false;
	}
	function attached(lam:Lamina, hole:Object, position:Number):Void {
		colorTransform.setTransform(nullTransform);
		//trace("ATTACHING: " + position);
		attachment = {laminaId:lam.id, holeId:hole.id, position:position};
	}
	function detached():Void {
		colorTransform.setTransform(greyTransform);		
	}
	function nudgeLaminae(dx:Number, dy:Number):Void {
		var lState:Array = hook.laminaState();
		if(lState.length != 0) {
			_global.frozen=false;
			for(var i:Number=0; i < lState.length; i++) {
				var ls:Object = lState[i];
				ls.lam.nudgeTo(ls.lx + dx,ls.ly + dy);
			}	
		}
		x = _x;
		y = _y;
	}
	function dragLaminae() {
		x = _x;
		y = _y;
		var lState:Array = hook.laminaState();
		if(lState.length != 0) {
			_global.frozen=false;
			ml = createEmptyMovieClip("ml", getNextHighestDepth());
			//ml.stand = this;
			ml.lState = lState;
			ml.mx = _root._xmouse;
			ml.my = _root._ymouse;
			ml.move = function() {
				for(var i:Number=0; i < this.lState.length; i++) {
					var ls:Object = this.lState[i];
					var main:Main = Main(_parent._parent);
					if(main._xmouse < Stage.width 
					   && main._xmouse > 0 
					   && main._ymouse < Stage.height
					   && main._ymouse > 0) {
						this.dx = main._xmouse - this.mx;
						this.dy = main._ymouse - this.my;
						ls.lam.nudgeTo(ls.lx + this.dx,ls.ly + this.dy);
					}
				}
			}
			ml.onMouseDown = ml.onMouseUp = ml.onMouseMove = ml.move; 
		}
		else {
			ml.removeMovieClip();
			ml = null;
		}
	}
	//
	// Drop stand onto/upto table
	//
	var dropV:Number=0;
	var dropId:Number = null;
	function drop():Void {
		var myBounds = getBounds();
		var p:Object = {x:myBounds.xMax, y:myBounds.yMax};
		localToGlobal(p);
		var yMax=p.y;
		var tBounds = _parent.table.getBounds();
		var p:Object = {x:tBounds.xMin, y:tBounds.yMin};
		_parent.table.localToGlobal(p);
		var tyMin=p.y;
		var diff = tyMin - yMax;
		if(Math.abs(diff) > 0.1) {
			var dropG = (diff > 0) ? 10 : -10;
			var vadj = Math.min(diff, dropV+dropG);
			if(vadj < 0) {
				vadj = Math.max(diff, dropV+dropG)
			}
			dropV = vadj;
			_y += dropV;
			if(dropId == null) {
				dropId = setInterval(this, "drop", 33);
			}
			nudgeLaminae(0,dropV);
		}
		else {
			clearInterval(dropId);
			dropId = null;
		}
	}
	function traceBounds(b:Object):Void {
		trace("yMin="+b.yMin+" yMax="+b.yMax);
	}
	function onPress():Void {
		if(!movable) {
			return;
		}
		dragLaminae();
		//_global.frozen = true;
		this.startDrag();
	}
	var onReleaseOutside:Function = onRelease;
	var onRollOut:Function = onRelease;
	function onRelease():Void {
		if(!movable) {
			return;
		}
		_global.frozen = false;
		//_parent.thaw();
		this.stopDrag();
		if(ml != null) {
			// following block prevents you dragging things entirely
			// off the screen. 
			if(_parent._xmouse > Stage.width 
			   || _parent._xmouse < 0 
			   || _parent._ymouse < Stage.height
			   || _parent._ymouse > 0) {
				_x = x + ml.dx;
				_y = y + ml.dy;
			}
			ml.removeMovieClip();
		}
		else {
			var main:Main = Main(_parent);
			main.standMoved();
			//checkAttachment();
		}
		//drop();
	}
	function onRollOver() {
		//trace(toXML());
	}
}