﻿import Config;
import Pivot;
import Hook;
import Vector;
class Spring extends MovieClip {
	var config:Config;
	var hole:Pivot = null;
	var hook:Hook = null;
	var p0:Vector;
	var p1:Vector;
	var restLen:Number;
	var modulus:Number;
	var id:String;
	var dx:Number;
	var dy:Number;
	var len:Number;
	var theta:Number;
	var c:Number;
	var s:Number;
	function Spring() {
		if(modulus == null) {
			modulus = config.defaultModulus;
		}
		hole.spring = this;
		hook.spring = this;
		hook._visible = false;
		theta = 100*Math.PI/180;
		c = Math.cos(theta);
		s = Math.sin(theta);
		draw();
	}
	function draw():Void {
		clear();
		p0 = hole.globalXY; //getPivotXY(hole);
		p1 = hook.globalXY; //getPivotXY(hook);
		lineStyle(1,0,100);
		/*
		// Draw the spring as a spring
		moveTo(p0.x, p0.y+((p1.y > p0.y)?5:-5));
		var steps:Number = 10;
		var dx = (p1.x - p0.x)/steps;
		var dy = (p1.y - p0.y)/steps;
		var du = (dx*c-dy*s);
		var dv = (dx*s+dy*c);
		for(var i = 0; i < steps; i++) {
			moveTo(p0.x + i*dx-du, p0.y+i*dy-dv);
			lineTo(p0.x + (i+1)*dx+du, p0.y+(i+1)*dy+dv);
			//lineTo(p1.x, p1.y);
		}
		*/
		//
		// Draw the spring as a simple line
		//
		moveTo(p0.x, p0.y+((p1.y > p0.y)?5:-5));
		lineTo(p1.x, p1.y);
	}
	function get tension():Vector {
		p0 = hole.globalXY; 
		p1 = hook.globalXY;
		var d:Vector = p1.minus(p0);
		len = d.length();
		var T = (len - restLen)*modulus;
		//return {x:(T*dx/len), y:(T*dy/len)};
		return new Vector({x:(T*d.x/restLen), y:(T*d.y/restLen)})
	}
	function get rotation():Number {
		var v:Vector = p1.minus(p0);
		return Math.atan2(v.y,v.x)*180/Math.PI;
	}
	function tooltipText():String {
		var cfg:Array = config.springs;
		var s:String = "";
		var bob:Bob = Bob(hook._parent);
		if(cfg.ttMass) s += "Mass: " + bob.mass + "\n";
		if(cfg.ttWeight) s += "Weight: " + bob.mass * config.gravity + "\n";
		if(cfg.ttTension) s += "Tension: " + Math.round(tension.y) + "\n";
		if(cfg.ttLength) s += "Length: " + Math.round(len) + "\n";
		if(cfg.ttRestLen) s += "Rest Length: " + restLen + "\n";
		if(cfg.ttModulus) s += "Modulus: " + modulus + "\n";
		return s;
	}
	/*
	function tick(dt:Number):Void {
		draw();
	}
	*/
	//function onEnterFrame() {
	//	tick(1);
	//}
}