﻿import Config;
import Hook;
import Lamina;
import Table;
class Main extends MovieClip {
	public var config:Config;
	//private var mcl:MovieClipLoader;
	private var standDepth:Number = 50;
	private var hookDepth:Number = 100;
	private var laminaDepth:Number = 200;
	var stands:Array;
	var activeStands:Array;
	var hooks:Array;
	var laminas:Array;
	var springs:Array;
	var topLamina:Lamina;
	var table:Table;
	function Main() {
		//mcl = new MovieClipLoader();
		//mcl.addListener(this);
		var f:Object;
		laminas = [];
		hooks = [];
		stands = [];
		springs = [];
		activeStands = [];
		//
		// Add laminae
		//
		//trace("laminas.length="+config.laminas.length);
		var depth:Number = laminaDepth;
		for(var x:Number = 0; x < config.laminas.length; x++) {
			var lam:Object = config.laminas[x];
			var lamina:Lamina = Lamina(attachMovie("Lamina", "lam"+depth, depth, {config:config, iConfig:lam}));
			depth+=lam.maxClones;
			trace("Creating " + lamina.idname + " at depth "+lamina.getDepth());
			if(lam.x != null) {
				lamina._x = lam.x;
				lamina._y = lam.y;
			}	
			laminas.push(topLamina = lamina);
		}
		//
		// Add the springs
		//
		//trace("Springs: " + config.springs.length);
		for(var i = 0; i < config.springs.length; i++) {
			var s:Object = config.springs[i];
			if(s.wname == null) s.wname = "BaseWeight";
			if(s.wicon == null) s.wname = "GreyWeight";
			if(s.adjustable == null) s.adjustable = false;
			var hole:Pivot = Pivot(attachMovie(s.idname, s.id+"_hole", 3*i+1000, {free:s.movable, _x:s.x, _y:s.y}));
			var bob:Bob = Bob(attachMovie("StackedBob", "bob"+i, 3*i+1002, {config:config, idname:s.wname, icon:s.wicon, _x:(150+50*i), _y:300, mass:s.mass, adjustable:s.adjustable}));	
			var spring:Spring = Spring(attachMovie("Spring", s.id, 3*i+1001, {config:config, id:s.id, hole:hole, hook:bob.hook, restLen:s.restLen, modulus:s.modulus}));
			springs.push(spring);
		}
/*		
		// Add some masses
		var massCount:Number = 5;
		for(var i = 0; i < massCount; i++) {
			var freePivot:Pivot = Pivot(attachMovie("Ring", "pivot"+i+1, 3*i+1000, {free:true, _x:150+(50*i), _y:250}));	
			var bob:Bob = Bob(attachMovie("StackedBob", "bob"+i, 3*i+101, {config:config, idname:"BaseWeight", icon:"GreyWeight", _x:(150+50*i), _y:300, mass:(i-2)*2+1}));	
			var spring:Spring = Spring(attachMovie("Spring", "spring"+i, 3*i+102, {config:config, hole:freePivot, hook:bob.hook, restLen:25}));
		}
*/
		//trace("Table: " + config.table);
		var t:Object = config.table;
		//trace(t.x + ","+t.y+","+t.width+","+t.height);
		table = Table(attachMovie(t.idname, t.id, t.depth, {iConfig:t}));

		//
		// Add supporting stands
		//
		//trace(config.stands[0].idname);
		for(var x:Number = 0; x < config.stands.length; x++) {
			var s:Object = config.stands[x];
			var stand:Stand = Stand(attachMovie(s.idname, "stand"+standDepth, standDepth++, {iConfig:s}));
			stands.push(stand);
			hooks.push(stand.hook);
			//stand.drop();
		}
	
		//
		// Create configured attachments
		//
		for(var i = 0; i < laminas.length; i++) {
			var lamina = Lamina(laminas[i]);
			lamina.createAttachments();
		}
		// freeze initially
		_global.frozen = false;
		standMoved();
	}
	function standMoved() {
		for(var i:Number = 0; i < laminas.length; i++) {
			var lam:Lamina = Lamina(laminas[i]);
			lam.moved();
		}
	}
	function getLaminaById(id:String):Lamina {
		for(var i:Number = 0; i < laminas.length; i++) {
			var lam:Lamina = Lamina(laminas[i]);
			if(lam.id == id) {
				return lam;
			}
		}
		return null;
	}
	function getSpringById(id:String):Spring {
		for(var i:Number = 0; i < springs.length; i++) {
			var s:Spring = Spring(springs[i]);
			if(s.id == id) {
				return s;
			}
		}
		return null;
	}
	function onLoadError() {
		trace("load error");
	}
	function onLoadInit(mc:MovieClip) {
		//trace("MovieClip loaded");
		mc._parent.assignMask();
	}
	function tick() {
	}
}