﻿import BaseWeight;
import Config;
import Grid;
import Hook;
import Pivot;
//import Hole;
class Lamina extends MovieClip {
	public var config:Config;
	public var iConfig:Object;
	static var clones:Array = [];
	var cloneId:Number = 0;
	//public var selected:Boolean = false; #TODO
	var _pivots:Array;
	//var _slots:Array;
	var hookClips:Array;
	var hook:Hook = null;
	var holeDepth:Number = 100;
	var activeHole:Pivot = null;
	var _holesConfig:Array = null;
	var _hooksConfig:Array = null;
	var g:Vector; //gravity
	var centreOfGravity:Vector = null;
	var momentOfInertia:Number = 0;
	//var mass:Number = 30;
	var velocity:Vector;
	var omega:Number = 0;
	var resultant:Vector;
	var image:MovieClip;
	var holeMask:MovieClip;
	var holePosition:Vector;
	var hookDepth = 200;
	var listenerDepth = 300;
	var colorTransform:Color;
	var greyTransform:Object;
	var nullTransform:Object;
	//var holeBorder:MovieClip;
	var mask:MovieClip;
	var grid:MovieClip;
	//var gridSize:Number;
	var gridTicks:Number = 5;
	var gridTocks:Number = 10;
	var gridXmax:Number = 40;
	var gridYmax:Number = 20;
	var gridX0:Number = 20;
	var gridY0:Number = 10;
	static var instances:Array = [];
	function Lamina() {
		//trace("There are " + holes.length + " holes");
		//trace("There are " + hooks.length + " hooks");
		if(movable) {
			registerClone();
		}
		if(hookClips == null) {
			hookClips = new Array();
		}
		if(_pivots == null) {
			_pivots = new Array();
		}
		if(velocity == null) {
			velocity = new Vector({x:0,y:0});
		}
		g = new Vector({x:0, y:config.gravity});
		//draw(_mass);
		resultant = g.times(mass);

		recalibrate();
		instances.push(this);
		
		_x = x;
		_y = y;
		//trace("Lamina mass = "+mass);
		if(idname != null) {
			
			if(springId == null) {
				image = attachMovie(idname, "image", 1, {_alpha:50});
				//
				// Create holes
				//
				holeMask = drawHoles();
				for(var i:Number = 0; i < holes.length; i++) {
					var h:Object = holes[i];
					var holeBorder = image.createEmptyMovieClip("holeBorder"+i, 2+i);
					drawRound(holeBorder, h);
					h.border = holeBorder;
				}
				image.setMask(holeMask);
			}
			else {
				image = BaseWeight(attachMovie(idname, "mass", 0, {idname:weightIcon}));
				image.draw(mass);
				image._x -= image.centreOfGravity._x;
				image._y -= image.centreOfGravity._y;
			}
			//
			// Create hooks
			//
			//trace("hooks.length = " + hooks.length);
			for(var i:Number = 0; i < hooks.length; i++) {
				var k:Object = hooks[i];
				var hk:Hook = Hook(attachMovie(k.idname, "hook"+i, hookDepth+i,
												 {_x:k.x, _y:k.y, lamina:this, label:k.label, attachments:k.attachments}));
				//hook.hitArea=hook;
				//trace("created "+hook);
				hookClips.push(hk);
				_parent.hooks.push(hk);
			}
			
		}
		/*
		// This code works, but tickles a memory leak in Flash8 player
		mask = attachMovie(idname, "mask", 3);
		if(gridSize > 0 && grid == null) {
			grid = Grid(attachMovie("Grid", "grid", 2, {unit:gridSize, ticks:gridTicks, tocks:gridTocks, xmax:gridXmax, ymax:gridYmax, _x:(-gridSize*gridX0), _y:(-gridSize*gridY0)}));
			if(image != null) {
				grid.setMask(mask);
			}
		}
		*/
		
		// create colour transforms
		colorTransform = new Color(this);
		nullTransform = colorTransform.getTransform();
		greyTransform = {ra:100,rb:0,ga:100,gc:0,ba:100,bb:0, aa:100, ab:0};
		if(movable) {
			image.onPress = function() {
				tick();
				_parent.tooltip(false);
				_global.frozen = false;
				//_parent.makeTop();
				_parent.offHook();
				_parent.startDrag(false);
				_parent.rotateTo(0);
				_parent.saveLaminaeState();
				//_parent.diffLaminaeState();
				_parent.dragLaminae();
				_parent.ml.move();
			}		
			image.onRelease = function() {
				_parent.tooltip(false);
				_parent.stopDrag();
				_parent.moved(true);
				if(_parent.hook == null) {
					//trace("DROP??? hook="+_parent.hook);
					//clearInterval(dropId);
					//_parent.drop();
					_parent.deleteClone();
				}
			}
			image.onReleaseOutside = image.onRelease;
		}
		image.onRollOver = function() {
			if(_parent.movable) {
				_alpha = 100;
				_parent.tooltip(true);
			}
			//trace(_parent.toXML());
		}
		image.onRollOut = function() {
			if(_parent.movable) {
				_parent.tooltip(false);
				_alpha = 50;
			}
			//trace(_parent.toXML());
		}
		if(hook == null) {
			offHook();
		}
		thaw();
		//trace("lamina hook initially "+hook);
		//moved();
	}
	function tooltip(show:Boolean):Void {
		if(ttShow) {
			if(show) {
				if(hook == null) {
					_root.tt.tooltipText = "Drag to a hook";
				}
				else {
					_root.tt.tooltipText = hook.tooltipText();
				}
			}
			_root.tt.tooltipShow = show;
		}
	}
	function registerClone():Void {
		if(movable) {
			// movable laminae clone when hooked and 
			// delete when unhooked
			if(clones[idname] == null) {
				clones[idname] = [];
				clones[idname].depth = getDepth();
			}
			var clone = clones[idname];
			clone[getDepth() - clone.depth] = this;
		}			
	}
	function deregisterClone():Void {
		var siblings:Array = clones[idname];
		for(var i = 0; i < siblings.length; i++) {
			var clone:Lamina = Lamina(siblings[i]);
			if(clone == this) {
				/*
				for(var j = i+1; j < siblings.length; j++) {
					this.swapDepths(siblings[j]);
				}
				*/
				siblings[i]=null;
				break;
			}
		}	
	}
	function createAttachments():Void {
		if(hook == null) {
			return;
		}
		for(var i:Number=0; i < hookClips.length; i++) {
			var hk:Hook = Hook(hookClips[i]);
			if(hk.attachments != null) {
				trace("hook "+ hk + " has attachment");
				for(var a:Number = 0; a < hk.attachments.length; a++) {
					var attachment:Object = hk.attachments[a];
					if(attachment.laminaId != null) {
						var toClone:Lamina = _parent.getLaminaById(attachment.laminaId);
						var hole:Object = toClone.getHoleById(attachment.holeId);
						//trace("toClone = "+ toClone);
						var clone:Lamina = toClone.createClone(hook);
						clone._x = hk.globalXY.x - hole.x1;
						clone._y = hk.globalXY.y - hole.y1;
					}
					if(attachment.springId != null) {
						var spring:Spring = _parent.getSpringById(attachment.springId);
						spring.hole.attachMe(this, hk); 
					}
					//trace("clone = " + clone + "@(" + clone._x + ", "+clone._y+")");
				}
			}
		}
	}
	function getHoleById(holeId:String):Object {
		for(var i:Number = 0; i < holes.length; i++) {
			var hole:Object = holes[i];
			if(hole.holeId == holeId) {
				return hole;
			}
		}
		return {radius:5, x1:0, y1:0};
	}
	function createClone(hook:Hook):Lamina {
		if(!movable) {
			//trace("1111");
			return null;
		}
		var siblings:Array = clones[idname];
		var index:Number = -1;
		var count:Number = 0;
		for(var i = 0; i < iConfig.maxClones; i++) {
			var clone:Lamina = Lamina(siblings[i]);
			if(clone==null) {
				index = i;
				continue;
			}
			else {
				if(clone.hook == null) {
					if(hook == null) {
						//trace("2222");
						return null;
					}
				}
			}
		}
		if(index < 0) {
			//trace("3333");
			return null;
		}
		var newDepth = siblings.depth+index;
		var lamina:Lamina = Lamina(_parent.attachMovie("Lamina", idname+newDepth, newDepth, {config:config, iConfig:iConfig}));
		trace("Creating lamina " + idname + " at depth "+lamina.getDepth() + " parent="+_parent);
		if(iConfig.x != null && iConfig.y != null) {
			lamina._x = iConfig.x;
			lamina._y = iConfig.y;
		}
		_parent.laminas.push(lamina);
		return lamina;
	}
	function deleteClone() {
		if(!movable) {
			return;
		}
		var siblings:Array = clones[idname];
		//var count:Number = 0;
		var doit:Boolean = false;
		for(var i = 0; i < siblings.length; i++) {
			var clone = Lamina(siblings[i]);
			if(clone == this) {
				continue;
			}
			trace("["+i+"]="+clone.hook);
			if(clone != null) {
				if(clone.hook == null) {
					doit = true;
				}
			}
		}
		if(!doit) {
			_x = iConfig.x;
			_y = iConfig.y;
			return;
		}
		trace("Deleting Lamina "+idname+" at depth " + this.getDepth());
		//hook.removeLamina(this);
		removeAllPivots();
		mask.removeMovieClip();
		image.removeMovieClip();
		delete holePosition;
		deregisterClone();
		this.removeMovieClip();
	}
	//
	// Drag child laminae along if we move
	//
	var ml:MovieClip;
	function saveLaminaeState() {
		ml = createEmptyMovieClip("ml", listenerDepth);
		ml.mouseIsUp = false;
		ml.lStates = [];
		for(var j=0; j < hookClips.length; j++) {
			var hk:Hook = Hook(hookClips[j]);
			var lState:Array = hk.laminaState();
			ml.lStates[j] = lState;
		}
		
	}
	function diffLaminaeState() {
		for(var j=0; j < hookClips.length; j++) {
			var hk:Hook = Hook(hookClips[j]);
			ml.lStates[j] = hk.diffLaminaState(ml.lStates[j]);
		}		
	}
	function dragLaminae() {
		//onEnterFrame = undefined;
		/*
		ml = createEmptyMovieClip("ml", listenerDepth);
		ml.lStates = [];
		for(var j=0; j < hookClips.length; j++) {
			var hk:Hook = Hook(hookClips[j]);
			var lState:Array = hk.laminaState();
			ml.lStates[j] = lState;
		}
		*/
		ml.mx = _parent._xmouse;
		ml.my = _parent._ymouse;
		ml.move = function() {
			for(var j=0; j < this.lStates.length; j++) {
				var lState:Array = this.lStates[j];
				for(var i:Number=0; i < lState.length; i++) {
					var ls:Object = lState[i];
					var main:Main = Main(_parent._parent);
					if(main._xmouse < Stage.width 
					   && main._xmouse > 0 
					   && main._ymouse < Stage.height
					   && main._ymouse > 0) {
						this.dx = main._xmouse - this.mx;
						this.dy = main._ymouse - this.my;
						ls.lam.nudgeTo(ls.lx + this.dx,ls.ly + this.dy);
					}
				}
			}
		}
		ml.onMouseMove = ml.move; 
		ml.onMouseDown = function() {
			this.mouseIsUp = true;
			this.move();
		}
		ml.onMouseDown = function() {
			this.mouseIsUp = false;
		}
		ml.onMouseUp = function() {
			this.mouseIsUp = true;
			_parent.thaw();
			this.removeMovieClip();
		}
	}
	function makeTop():Void {
		var main:Main = Main(_parent);
		if(this != main.topLamina) {
			swapDepths(main.topLamina);
			main.topLamina = this;
			//trace("HOOKS.LENGTH="+hookClips.length);
			for(var i=0; i < hookClips.length; i++) {
				var hk:Hook = Hook(hookClips[i]);
				for(var j=0; j < hk.laminas.length; j++) {
					//trace("LAMINAE LENGTH="+hk.laminas.length);
					var lam:Lamina = Lamina(hk.laminas[j]);
					lam.makeTop();
				}
			}
		}
	}
	function drawHoles():MovieClip {
		var holeMask:MovieClip = createEmptyMovieClip("holeMask",4);		
		var pad:Number = 0;
		var b:Object = image.getBounds();
		var x0:Number = b.xMin-pad;
		var x1:Number = b.xMax+pad;
		var y0:Number = b.yMin-pad;
		var y1:Number = b.yMax+pad;
		holeMask.lineStyle(1,0,100);
		holeMask.beginFill(0,100);
		holeMask.lineTo(x0,y0);
		holeMask.lineTo(x1,y0);
		holeMask.lineTo(x1,y1);
		holeMask.lineTo(x0,y1);
		holeMask.lineTo(x0,y0);
		for(var i:Number = 0; i < holes.length; i++) {
			drawRound(holeMask, holes[i]);
		}
		holeMask.endFill();
		return holeMask;
	}
	function recalibrate() {
		momentOfInertia = getMomentOfInertia();
	}
	function set pivots(pivotList:Array) {
		_pivots = pivotList;
		recalibrate();
		//trace(momentOfInertia);
	}
	//function set mass(w:Number):Void {
	//	_mass = w;
	//	draw(w);
	//}

	//
	// instance configuration
	//
	function get id():String {
		return iConfig.id;
	}
	function get holes():Array {
		if(_holesConfig == null) {
			// DeepClone holes
			_holesConfig = [];
			for(var i = 0; i < iConfig.holes.length; i++) {
				var h = {};
				var hcfg = iConfig.holes[i];
				for(var prop in hcfg) {
					h[prop] = hcfg[prop];
				}
				_holesConfig[i] = h;
			}
		}
		return _holesConfig;
	}
	function get hooks():Array {
		if(_hooksConfig == null) {
			_hooksConfig = iConfig.hooks.concat();
		}
		return _hooksConfig;
	}
	function get idname():String {
		return iConfig.idname;
	}
	function get maxClones():Number {
		if(iConfig.maxClones == null || iConfig.maxClones==undefined) {
			return 1;
		}
		return iConfig.maxClones;
	}
	function get x():Number {
		return iConfig.x;
	}
	function get y():Number {
		return iConfig.y;
	}
	function get movable():Boolean {
		return iConfig.movable == null ? "true" : iConfig.movable;
	}
	function get deletable():Boolean {
		return iConfig.deletable == null ? "false" : iConfig.deletable;
	}
	function get gridSize():Number {
		return iConfig.gridSize == null ? 1000 : iConfig.gridSize;
	}
	function get mass():Number {
		var m:Number = (iConfig.mass == null || iConfig.mass <= 0)? 30 : iConfig.mass;
		if(m < 0) {
			// it's a baloon
			m = -m;
			g = g.negate();
		}
		return m;
	}
	function get myCentreOfGravity():Vector {
		return new Vector({x:iConfig.cog_x, y:iConfig.cog_y});
	}
	function get cog_x():Number {
		return iConfig.cog_x;
	}
	function get cog_y():Number {
		return iConfig.cog_y;
	}
	function get springId():String {
		return iConfig.stringId;
	}
	function get weightIcon():String {
		return iConfig.weightIcon;
	}
	function get ttShow():Boolean {
		return iConfig.tooltipShow == null ? true : iConfig.tooltipShow;
	}
	function get continuous():Boolean {
		return iConfig.continuous == null ? false : iConfig.continuous;
	}
	//
	// capture screen to XML
	//
	function toXML():String {
		//<lamina id="bar" x="275" y="300" idname="BalanceBar" movable="true">
		//	<holes sequence="true">
		//		<hole id="h1" radius="5" x1="-50" y1="5" x2="50" y2="5" isHook="true"/>
		//	</holes>
		//</lamina>
		var s:String = '<lamina id="'+id+'" idname="'+idname+'" movable="'+movable+'" deletable="'+deletable+'" x="'+_x+'" y="'+_y+'">';
		if(holes != null && holes.length > 0) {
			s += "\n\t<holes>\n";
			for(var i:Number = 0; i < holes.length; i++) {
				var h:Object = holes[i];
				s += "\t\t<hole "+'id="'+h.id+'" radius="'+h.radius+'" x1="'+h.x1+'" y1="'+h.y1+'" '; //isHook="'+h.isHook+'" ';
				if(h.x2 != null) {
					s += 'x2="'+h.x2+'" y2="'+h.y2+'"';
				}
				s += "/>\n";
			}
			s += "\t</holes>\n</lamina>";
		}
		else {
			s += "/>";
		}
		return s;
	}
	//
	// Lamina has just been moved (manually)
	//
	function moved(snap:Boolean) {
		//trace("Moved");
		var hooks:Array = _parent.hooks;
		for(var i:Number = 0; hook == null && i < hooks.length; i++) {
			var hk:Hook = Hook(hooks[i]);
			if(hk._parent == this) {
				// ignore hooks belonging to this lamina
				continue;
			}
			for(var j:Number = 0; j < holes.length; j++) {
				var h:Object = holes[j];
				var p:Object = {x:h.border._x, y:h.border._y};
				localToGlobal(p);
				var p1:Vector = new Vector(p);
				var v:Vector = hk.globalXY;
				var tolerance = 10;
				var hit:Boolean = (h.x2==null) ? (v.minus(p1).length() < tolerance) : hk.hitTest(h.border);
				if(hit) {
					trace(v.x + ", " + v.y + " == " + p.x + ", " + p.y);
					//trace("Moved hit");
					//var r:Number = _rotation;
					//rotateTo(0);
					var t = holeToHook(hk, h);
					onHook(hk, h, t);
					//rotateTo(r);
					return;
				}
			}
		}
	}
	//
	// On or off a hook
	//
	var timer:Number;
	function offHook() {
		if(hook != null) {
			hook.removeLamina(this);
		}
		hook = null;
		colorTransform.setTransform(greyTransform);
		//rotateTo(0);
		/*
		for(var i:Number = 0; i < _pivots.length; i++) {
			var pivot:Pivot = Pivot(_pivots[i]);
			if(pivot == hole) {
				_pivots.splice(i, 1);
				break;
			}
		}
		hole.removeMovieClip();
		*/
		//_global.frozen = true;
	}
	function onHook(hk:Hook, h:Object, t:Number) {
		hook = hk;
		//trace("onHook hole@("+h.x1+","+h.y1+") hook="+hk + " this="+this+"("+_x+", "+_y+") hook._parent="+hook._parent);
		if(t == null) {
			holePosition = new Vector({x:h.x1, y:h.y1});
		}
		else {
			var u = 1-t;
			holePosition = new Vector({x:(h.x1*u+h.x2*t), y:(h.y1*u+h.y2*t)});
		}
		//hole = Pivot(attachMovie("Ring", "hole", holeDepth, {_x:holePosition.x, _y:holePosition.y}));
		hk.addLamina(this, h, t);
		colorTransform.setTransform(nullTransform);
		_global.frozen = false;
		//_pivots.push(hole);
		thaw();
		if(hk.lamina != null) {
			//trace("thawing "+hk.lamina);
			hk.lamina.thaw();
		}
		//trace("creating Clone");
		createClone();
	}
	function holeOnHook(hk:Hook, holeId:String, t:Number):Object {
		//trace("holeOnHook hook="+hk);
		for(var i:Number=0; i < holes.length; i++) {
			var h:Object = holes[i];
			if(h.id == holeId) {
				holeToHook(hk, h, t);
				onHook(hk, h, t);
				return h;
			}
		}
		return null
	}
	function holeToHook(hk:Hook, h:Object, t:Number):Number {
		var p:Vector = hk._parent.globalXY(new Vector({x:hk._x, y:hk._y}));
		//trace("hook parent x :" + hk._parent._x + "==" + p.x);
		//trace("hook parent y :" + hk._parent._y + "==" + p.y);
		//var dfx = hk._parent._x + hk._x - h.x1;
		//var dfy = hk._parent._y + hk._y - h.y1;
		var dfx = p.x - h.x1;
		var dfy = p.y - h.y1;
		if(h.x2 == null) {
			_x = dfx;
			_y = dfy;
		}
		else {
			var dfxx = dfx - _x;
			var dfyy = dfy - _y;
			var dhx = h.x2 - h.x1;
			var dhy = h.y2 - h.y1;
			if(dhx==0) {
				_x = dfx;
				t = (t==null ? tStrict(dfyy/dhy) : t);
				_y = dhy - dhy*t;
			}
			else if(dhy==0) {
				t = (t==null ? tStrict(dfxx/dhx) : t);
				_x = dfx - dhx*t;
				_y = dfy;
			}
			else {
				t = t==null ? (tStrict(dfxx/dhx)+tStrict(dfyy/dhy))/2 : t;
				_x = dfx - t*dhx;
				_y = dfy - t*dhy;
			}
		}
		return t;
	}
	function tOK(t:Number) : Boolean {
		return t > -0.1 && t < 1.1;
	}
	function tStrict(t:Number) : Number {
		return t < 0? 0 : (t > 1 ? 1 : t);
	}
	function drawRound(mc:MovieClip, hole:Object):Void {
		var d:Number = Math.PI/6;
		//trace("isNaN(x1)="+isNaN(hole.x1)+ " x1="+hole.x1);
		//trace("isNaN(radius)="+isNaN(hole.radius)+ " radius="+hole.radius);
		//trace("isHook="+hole.isHook);
		mc.lineStyle(2, 0x666666,100);
		if(hole.x2 == null || hole.y2 == null) {
			//hole.x1 = Number(hole.x1);
			//hole.y1 = Number(hole.y1);
			//hole.radius = Number(hole.radius);
			mc.moveTo(hole.x1+hole.radius,hole.y1);
			// Draw round hole
			for(var t:Number = -d; t >= -2*Math.PI-0.5; t-=d) {

				//trace("lineTo: ( "+(hole.x1+hole.radius*Math.cos(t))+","+(hole.y1+hole.radius*Math.sin(t))+")");
				mc.lineTo(hole.x1+hole.radius*Math.cos(t), hole.y1+hole.radius*Math.sin(t));
			}
		}
		else {
			var a:Number = Math.atan2(hole.y2-hole.y1, hole.x2-hole.x1) - Math.PI/2;
			// Start on hole1
			mc.moveTo(hole.x1+hole.radius*Math.cos(a),hole.y1+hole.radius*Math.sin(a));
			// Swing round it
			for(var t:Number = -d; t > -Math.PI; t-=d) {
				mc.lineTo(hole.x1+hole.radius*Math.cos(a+t), hole.y1+hole.radius*Math.sin(a+t));
			}
			// Shoot over to hole2
			var b:Number = a - Math.PI;
			// Swing round it
			mc.lineTo(hole.x2+hole.radius*Math.cos(b),hole.y2+hole.radius*Math.sin(b));
			for(var t:Number = -d; t > -Math.PI; t-=d) {
				mc.lineTo(hole.x2+hole.radius*Math.cos(b+t), hole.y2+hole.radius*Math.sin(b+t));
			}
			// Back to hole 1
			mc.lineTo(hole.x1+hole.radius*Math.cos(a),hole.y1+hole.radius*Math.sin(a));
		}
	}
	function removeAllPivots() {
		for(var i = 0; i < _pivots.length; i++) {
			var p:Pivot = Pivot(_pivots[i]);
			//trace("UNHOOKING ME: "+idname+getDepth());
			p.unhookMe();
		}
		_pivots = [];
	}
	function removePivot(pivot:Pivot) {
		for(var i = 0; i < _pivots.length; i++) {
			var p:Pivot = Pivot(_pivots[i]);
			if(p == pivot) {
				//trace("removing pivot: "+i);
				_pivots.splice(i, 1);
				p.removeMovieClip();
			}
		}
		recalibrate();
	}
	function addPivot(pivot:Pivot):Void {
		_pivots.push(pivot);
		recalibrate();
		onEnterFrame = tick;
	}
	function getCentreOfRotation():Vector {
		var cor:Vector;
		if(hook != null) {
			cor = hook.globalXY;
		}
		else {
			//
			// We still need a centre so we can rotate about it even if
			// this is a light lamina. To do this, find the centre of 
			// gravity of imaginary masses attached at each pivot point,
			//
			cor = new Vector({x:0, y:0});
			for(var i:Number = 0; i < _pivots.length; i++) {
				var p:Pivot = Pivot(_pivots[i]);
				cor = cor.plus(p.globalXY);
			}
			cor = cor.times(1/_pivots.length);
		}
		return cor;
	}
	function getMomentOfInertia():Number {
		omega = 0;
		var cor:Vector = getCentreOfRotation();
		var I:Number = 0;
		for(var j:Number = 0; j < _pivots.length; j++) {
			var p:Pivot = Pivot(_pivots[j]);
			I += cor.minus(p.globalXY).length();
		}
		if(_pivots.length == 0) {
			I = cor.minus(globalXY(myCentreOfGravity)).length();
		}
		return Math.min(1000, (I * mass/_pivots.length));
	}
	function getHook():Hook {
		return hook;
	}
	function rotate(angle:Number):Void {
		rSmooth = rSmooth*0.9 + angle*0.1;
		/*
		if((Math.abs(rSmooth) < 0.01) && (angle < 0.5)) {
			//trace("freezing");
			onEnterFrame = null;
			if(allFrozen()) {
				_global.frozen = true;
			}
			return;
		}
		*/
		rotateTo(_rotation + angle);
	}
	function allFrozen():Boolean {
		for(var i = 0; i < instances.length; i++) {
			var rb:Lamina = Lamina(instances[i]);
			if(rb.onEnterFrame != null) {
				return false;
			}
		}
		return true;
	}
	var rSmooth:Number = 0;
	function globalXY(v:Vector):Vector {
		var p:Object = {x:v.x,y:v.y};
		this.localToGlobal(p);
		//var parentP = new Vector({x:_parent._x, y:_parent._y});
		//return v.plus(parentP);
		return new Vector(p);
	}
	function hookGlobalXY():Vector {
		var p:Object = {x:hook._x,y:hook._y}
		localToGlobal(p);
		return new Vector(p);
	}
	function rotateTo(angle:Number):Void {
		var hole:Vector = globalXY(holePosition);
		//trace(holePosition + " = g:"+ hole);
		_rotation = angle;
		//_parent.dragLaminae();
		var hole2:Vector = globalXY(holePosition);
		//trace(hole2.x - hole.x);
		_x -= (hole2.x - hole.x);
		_y -= (hole2.y - hole.y);
	}
	function nudgeTo(x:Number, y:Number):Void {
		var r:Number = _rotation;
		rotateTo(0);
		_x = x;
		_y = y;
		rotateTo(r);
		recalibrate();
	}
	function nudgeBy(dx:Number, dy:Number):Void {
		var r:Number = _rotation;
		rotateTo(0);
		_x += dx;
		_y += dy;
		rotateTo(r);
		recalibrate();
	}
	function supportMoved(pivot:Pivot):Vector {
		var gp:Vector = pivot.globalXY;
		var h:Vector = globalXY(holePosition);
		/*
		if(idname=="Tab5") {
			var b:Object = getBounds();
			trace("bounds="+b.xMin +", "+b.yMin +", "+b.xMax +", "+b.yMax);
			trace("this="+this+ " @("+_x+", "+_y+")"+" holePosition="+holePosition);
			trace("pivot.globalXY="+pivot.globalXY+"  h="+globalXY(holePosition));
		}
		*/
		//nudgeTo(gp.x-h.x+_x, gp.y-h.y+_y);
		nudgeBy(gp.x-h.x, gp.y-h.y);
		return resultant;
	}
	function tick():Void {
		if(_global.frozen) {
			//trace("frozen");
			return;
		}
		/*
		if(_pivots.length == 0) {
			//trace("no pivots");
			onEnterFrame = null;
		}
		else */{
			//trace("tick");
			var dt:Number = 1;
			var couple:Number = 0;
			resultant = g.times(mass);//new Vector({x:0,y:0});
			//if(_pivots.length != 0) trace("Pivots length = "+_pivots.length);
			for(var i:Number=0; i < _pivots.length; i++) {
				var pivot:Pivot = Pivot(_pivots[i]);
				//trace("hook is at:" + hook.globalXY);
				//trace("cog="+centreOfGravity + " pivot = "+pivot + " globalPivot="+pivot.globalXY);
				var r:Vector = hook.globalXY.minus(pivot.globalXY);
				var force:Vector;
				if(pivot.lamina != null) {

					force = pivot.lamina.supportMoved(pivot);

				}
				else {
					// The pivot has a spring attached
					//trace("spring for: "+pivot);
					force = pivot.spring.tension;
					pivot.spring.draw();
				}
				couple += r.crozz(force);
				resultant = resultant.plus(force);
			}
			if(_pivots.length == 0) {
				// Use our own cog ONLY if there are no others
				var r:Vector = hook.globalXY.minus(globalXY(myCentreOfGravity));
				couple += r.crozz(resultant);
			}
			//trace("resultant="+resultant + "couple="+couple+" cog="+centreOfGravity);
			omega = omega*config.viscosity;
			omega += couple/momentOfInertia;
			rotate(omega*dt);
			/*
			// Drop to table level
			if(hook == null && ml.mouseIsUp) {
				if(_y + image._height < _parent.table._y) {
					velocity = velocity.times(config.viscosity).plus(resultant.times(dt/mass));
					_x += velocity.x;
					_y += velocity.y;
					if(_y + image._height > _parent.table._y) {
						trace(_y + " h="+image._height + " > "+_parent.table._y);
						velocity.y = 0;
						_y = _parent._table._y - _height;
					}
				}
			}
			*/
		}
	}
	//
	// Drop lamina onto/upto table
	//
	var dropV:Number=0;
	var dropId:Number = null;
	function drop():Void {
		return;
		if(hook != null) {
			if(dropId != null) {
				clearInterval(dropId);
			}
			return;
		}
		//trace("DROPPING");
		rotateTo(0);
		var myBounds = getBounds();
		var p:Object = {x:myBounds.xMax, y:myBounds.yMax};
		localToGlobal(p);
		var yMax=p.y;
		var tBounds = _parent.table.getBounds();
		var p:Object = {x:tBounds.xMin, y:tBounds.yMin};
		_parent.table.localToGlobal(p);
		var tyMin=p.y;
		var diff = tyMin - yMax;
		if(Math.abs(diff) > 0.1) {
			var dropG = (diff > 0) ? 10 : -10;
			var vadj = Math.min(diff, dropV+dropG);
			if(vadj < 0) {
				vadj = Math.max(diff, dropV+dropG)
			}
			dropV = vadj;
			_y += dropV;
			if(dropId == null) {
				dropId = setInterval(this, "drop", 33);
			}
			nudgeChildLaminae(0,dropV);
		}
		else {
			clearInterval(dropId);
			dropId = null;
		}
	}
	function nudgeChildLaminae(dx:Number, dy:Number):Void {
		for(var j=0; j < hookClips.length; j++) {
			var hk:Hook = Hook(hookClips[j]);
			var lState:Array = hk.laminaState();
			if(lState.length != 0) {
				for(var i:Number=0; i < lState.length; i++) {
					var ls:Object = lState[i];
					ls.lam.nudgeTo(ls.lx + dx,ls.ly + dy);
				}	
			}
			//x = _x;
			//y = _y;
		}
	}
	function thaw() {
		//trace("thawing");
		recalibrate();
		onEnterFrame = tick;
	}
	function onEnterFrame() {
		tick();
	}
}