﻿import Stand;
import Lamina;
import Bob;
class Hook extends MovieClip {
	var x:Number = 0;
	var y:Number = 0;
	var laminas:Array; // hanging from this hook
	//	private var activeHoles:Array
	//
	// Hooks either have Main as a parent, or they have Bob as a parent.
	// Main hooks are either attached to Stands or to Laminae
	// Bob hooks are attached to their parent Bob.
	//
	var spring:Spring; // to which we are attached 
	var stand:Stand;  // to which we are attached
	var lamina:Lamina; // to which we are attached
	var label:String;
	var attachments:Array;
	var tf:TextField;
	function Hook() {
		laminas = [];
//		activeHoles = [];
//		springs = [];
		//trace("this.addLamina = "+addLamina);
		if(label != null && label != "") {
			var _mc = attachMovie("HookLabel", "tfmc", 1);
			_mc._x -= 10;
			_mc._y -= 25;
			_mc["tf"].text = label;
		}
	}
	function onPress():Void {
		//x = _x;
		//y = _y;
		//_global.frozen = true;
		//this.startDrag();
		for(var i=0; i < laminas.length; i++) {
			var lam:Lamina = Lamina(laminas[i]);
			lam.makeTop();
		}
		_root.tt.tooltipShow = false;
	}
	function onRelease():Void {
		//_global.frozen = false;
		//_parent.thaw();
		//this.stopDrag();
		//trace("HOOK onRelease");
		// bring any hanging laminae to the front if we click on their hook
	}
	function onRollOver():Void {
		_root.tt.tooltipText = tooltipText();
		_root.tt.tooltipShow = true;
	}
	function onRollOut():Void {
		_root.tt.tooltipShow = false;
	}
	function get globalXY():Vector {
		//var p:Object = {x:(_x+_width/2), y:(_y+_height/2)};
		var p:Object = {x:_x, y:_y};
		_parent.localToGlobal(p);
		return new Vector(p);
	}
	function addLamina(lam:Lamina, hole:Object, t:Number):Void {
		//trace("hook.addLamina: " + lam.id + "laminas = " + laminas.length);
		laminas.push(lam);
		if(stand != null) {
			stand.attached(lam, hole, t);
			lam.activeHole = Pivot(stand.attachMovie("Ring", "activeHole"+stand.holeDepth, stand.holeDepth++, {_x:_x, _y:_y, lamina:lam}));
		}
		else if(lamina != null) {
			//hang lam on lamina
			//trace("Hanging lamina "+lam +" at("+lam._x+", "+lam._y+")");
			lamina.addPivot(lam.activeHole = Pivot(lamina.attachMovie("Ring", "activeHole"+lamina.holeDepth, lamina.holeDepth++, {_x:_x, _y:_y, lamina:lam})));
		}
		else if(spring != null) {
			//hang lam on spring
		}
	}
	function removeLamina(lam:Lamina):Void {
		for(var i:Number=0; i < laminas.length; i++) {
			var lm:Lamina = laminas[i];
			if(lm == lam) {
				//trace("removing from hook: "+lam);
				laminas.splice(i,1);
				break;
			}
		}
		if(laminas.length == 0 && stand != null) {
			stand.detached();
		}
		if(lamina != null) {
			lamina.removePivot(lam.activeHole);
			//lam.activeHole.removeMovieClip();
		}
	}
	function laminaState():Array {
		var ls:Array = [];
		for(var i:Number=0; i < laminas.length; i++) {
			var lam:Lamina = Lamina(laminas[i]);
			var r = lam._rotation;
			lam.rotateTo(0);
			var h:Vector = lam.hook.globalXY;
			//ls[i] = {lam:lam, lx:lam._x, ly:lam._y};
			ls[i] = {lam:lam, lx:h.x, ly:h.y};
			//trace("lam lx==hx? "+lam._x+"=="+h.x+"  "+lam._y+"=="+h.y);
			lam.rotateTo(r);
		}
		return ls;
	}
	function diffLaminaState(ls:Array):Array {
		for(var i:Number=0; i < laminas.length; i++) {
			var lam:Lamina = Lamina(laminas[i]);
			var r = lam._rotation;
			lam.rotateTo(0);
			var h:Vector = globalXY;
			//trace("Entry: lx,y="+ls[i].lx+","+ls[i].ly);
			ls[i] = {lam:lam, lx:(ls[i].lx-h.x), ly:(ls[i].ly-h.y)};
			//trace(" Exit: lx,y="+ls[i].lx+","+ls[i].ly);
			lam.rotateTo(r);
		}
		return ls;
	}
	function toString():String {
		var s = "Hook@("+x+", "+y+")";
		return s;
	}
	function tooltipText():String {
		var s:String = "";
		var sep = "";
		for(var i = 0; i < laminas.length; i++) {
			var lam:Lamina = Lamina(laminas[i]);
			s += sep + lam.mass;
			sep = ", ";
		}
		if(s == "") {
			s = "Empty hook";
		}
		return s;
	}
	/*
	function doRelease() {
		_global.frozen = false;
		_parent.thaw();
		this.stopDrag();
		//trace(Lamina.instances.length);
		var drop:MovieClip = null;
		for(var i:Number = 0; i < Lamina.instances.length; i++) {
			var lamina:Lamina = Lamina(Lamina.instances[i]);
			drop = lamina.image;
			if(drop.hitTest(_level0._xmouse, _level0._ymouse, true)) {
				if(lamina == _parent) {
					// TODO: snap to parent slot here
					_parent.recalibrate();
					return;
				}
				else {
					_x = x;
					_y = y;
					return;
				}
			}
		}
		_x = x;
		_y = y;
		return;
	}
	*/
}