﻿import WeightIcon;
import Config;
import Pivot;
import Vector;
import Hook;
//
// Bobs have a mass and 1 hook which is attached to a spring
//
class Bob extends MovieClip {
	var config:Config;
	var hook:Hook = null;
	var _mass:Number;
	var mass_mc:WeightIcon;
	var idname:String;
	var icon:String;
	var v:Vector;
	var g:Vector;
	var adjustable:Boolean;
	function Bob() {
		v = new Vector({x:0, y:0});
		g = new Vector({x:0, y:config.gravity});
		if(_mass < 0) {
			// create baloon-like behaviour?
			_mass = -_mass;
			g = g.negate();
		}
		hook = Hook(attachMovie("Fulcrum", "hook", 1));
		draw(_mass);
	}
	function set mass(w:Number):Void {
		_mass = w;
		//draw(w);
	}
	function get mass():Number {
		return _mass;
	}
	function draw(w:Number):Void {
		//trace("drawing Bob of weight "+w+" idname="+idname+" icon="+icon);
		clear();
		mass_mc = WeightIcon(attachMovie(idname, "w0", 0, {idname:icon, adjustable:adjustable}));
		mass_mc.draw(_mass=w);
		mass_mc["_x"] -= mass_mc.getCentreOfGravity()._x;
		mass_mc["_y"] -= mass_mc.getCentreOfGravity()._y;
		//hook = Hook(attachMovie("Fulcrum", "hook", 1));
		//hook._x -= hook._width/2;
		//hook._y -= hook._height/2;
	}
	function redraw():Void {
		mass_mc.draw(_mass);
		//mass_mc["_x"] -= mass_mc.getCentreOfGravity()._x;
		//mass_mc["_y"] -= mass_mc.getCentreOfGravity()._y;		
	}
	function tick(dt:Number):Void {
		//
		var force:Vector = hook.spring.tension;
		if(hook == hook.spring.hook) {
			force = force.negate();
		}
		// Euler explicit:
		//v = v.times(config.viscosity).plus(force.plus(g.times(_mass)).times(dt/_mass));
		// Euler implicit:
		v = v.plus(force.plus(g.times(_mass)).times(dt)).times(1/(1+dt*config.k));
		_x += dt*v.x;
		_y += dt*v.y;
		hook.spring.draw();//tick(1);
		_rotation = -90+hook.spring.rotation;
	}
	/*
	function acc(pos:Vector, vel:Vector):Vector {
		var sx:Number = _x;
		var sy:Number = _y;
		//var t1:Vector = hook.spring.tension;
		_x = pos.x;
		_y = pos.y;
		//hook.spring.tick(1);
		var force:Vector = hook.spring.tension;
		//trace("T1 = "+t1.x +","+t1.y+ "  T2="+force.x+","+force.y);
		if(hook == hook.spring.hook) {
			force = force.negate();
		}
		// Euler explicit:
		_x = sx;
		_y = sy;
		//trace("config.k = "+config.k);
		return force.plus(g.times(_mass)).minus(vel.times(config.k)).times(1/_mass);
	}
	function rungeKutta2(dt:Number) {
		var pos:Vector = new Vector({x:_x, y:_y});
		var kv1_2:Vector = acc(pos, v).times(dt/2);
		var kp1_2:Vector = v.times(dt/2);
		var midpos:Vector = pos.plus(kp1_2);
		var midvel:Vector = v.plus(kv1_2);
		var kv2:Vector = acc(midpos,midvel).times(dt);
		var kp2:Vector = midvel.times(dt);
		_x += kp2.x;
		_y += kp2.y;
		v = v.plus(kv2);
		hook.spring.draw();//tick(1);
		_rotation = 90+hook.spring.rotation;
	}
	*/
	function onEnterFrame() {
		//rungeKutta2(0.5);
		tick(1);
	}
}