﻿import WeightIcon;
class Bag extends MovieClip implements WeightIcon {
	var idname:String;
	var _masses:Array;
	var _centreOfGravity:Object = null;
	var alpha:Number = 5;
	var k:Number = 0.5;
	var theta:Number = 2*Math.PI/1.618;
	var adjustable:Boolean;
	function Bag() {
		if(adjustable) {
			onRollOver = doRollOver;
		}
	}
	public function draw(w:Number):Void {
		_centreOfGravity = null;
		//trace("drawing " + w + "weights");
		clear();
		for(var i = 0; i < w; i++) {
			var _mc = attachMovie(idname, "w"+i, i);
			var xy:Object = getWeightXY(i, _mc);
			_mc._x = xy._x;
			_mc._y = xy._y;
			_mc._alpha=70;
			if(_masses == null) {
				_masses = [];
			}
			_masses.push(_mc);
		}
	}
	public function clear():Void {
		super.clear();
		for(var i = 0; i < _masses.length; i++) {
			var _mc:MovieClip = MovieClip(_masses[i]);
			_mc.removeMovieClip();
		}
		_masses = [];
	}
	public function getWeightXY(w:Number, clip_mc:MovieClip):Object {
		// Calculate the centre of the wth weight to be drawn
		var r:Number = alpha*Math.pow(w,k);
		var phi:Number = theta*w;
		return {_x:r*Math.cos(phi), _y:r*Math.sin(phi)};
	}
	public function getCentreOfGravity():Object {
		if(_centreOfGravity == null) {
			var mx:Number = 0;
			var my:Number = 0;
			for(var i = 0; i < _masses.length; i++) {
				var _mc = MovieClip(_masses[i]);
				mx += (_mc._x + _mc._width/2);
				my += (_mc._y + _mc._height/2);
			}
			_centreOfGravity = {_x:(mx/_masses.length), _y:(my/_masses.length)}
		}
		return _centreOfGravity;
	}
	var pm:MovieClip = null;
	//var intervalId:Number = null;
	function doRollOver() {
		//_alpha = 50;
		var bob:Bob = Bob(_parent);
		//_root.tt.tooltipText=""+bob.mass;
		//_root.tt.tooltipShow=true;
		if(pm != null) {
			clearInterval(pm.intervalId);
			return;
		}
		pm = _parent.attachMovie("PlusMinus", "pm", 1000);
		pm.bag = this;
		pm.bob = bob;
		pm.minus.pm = pm;
		pm.plus.pm = pm;
		pm.minus.onRelease = function() {
			//trace("-");
			//var bob:Bob = Bob(_parent._parent);
			//trace(bob);
			if(bob.mass > 0) {
				--bob.mass;
				bob.redraw();
			}
		}
		pm.plus.onRelease = function() {
			//trace("+");
			//var bob:Bob = Bob(_parent._parent);
			if(bob.mass < 32) {
				++bob.mass;
				bob.redraw();
			}
		}
		pm.minus.onRollOut = pm.plus.onRollOut = function() {
			//trace(pm.bag);
			pm.bag.removePM();
			//clearInterval(pm.intervalId);
			//pm.removeMovieClip();
		}
		pm.minus.onRollOver = pm.plus.onRollOver = function() {
			clearInterval(pm.intervalId);
		}
	}
	function removePM() {
		//trace("REMOVE");
		clearInterval(pm.intervalId);
		pm.removeMovieClip();
		pm = null;
	}
	function onRollOut() {
		//_alpha = 100;
		pm.intervalId = setInterval(this, "removePM", 2000);
	}
	function onPress() {
		_parent.startDrag();
	}
	function onRelease() {
		_parent.stopDrag();
	}
	function onReleaseOutside() {
		_parent.stopDrag();
	}
}