﻿
import Person;

class Population  extends MovieClip{
	
	static var GRID_LENGTH:Number = 320; //Grid side length.
	private var GRID_SQUARES:Number = 30; //Grid number of squares across.
	
	//Make sure person image fits inside 20*20 box so that following scale factor
	//is correct.
	private var PERSON_SCALE:Number = 100;
	
	//Initial number of people. Must be <= GRID_SQUARES^2.
	private var initPeople:Number = 1;
	//Initial number of ill people. 
	private var initIll:Number = 0;
	//Initial number of immune people. This + initIll must be <= initPeople.
	private var initImmune:Number = 0;
	
	public var currentPeople:Number = initPeople;
	public var currentIll:Number = initIll;
	
	private var days:Number = 5; //Number of days the disease lasts.
	private var incubationPeriod:Number = 0;
	
	private var probDie:Number = 0.99;//Probability of disease killing.
	private var probStay:Number = 0.2;//Probability person stays still on any go.
	private var probContract:Number=0.99;//Probability get illness if next to ill person.
	
	//Possible behaviours are NORMAL, STATIC, ISOLATED.
	private var behaviourIfIll:String = "normal";
	private var immunity:Boolean = false;
	
	//Whether ith,jth position occupied.
	private var occupied:Array;
	
	//Data about each person.
	public var dead:Number = 0;
	public var neverGotIll:Number=0;
	public var gotIllAndRecovered:Number=0;
	
	function Population() {
		//behaviourIfIll = new String("normal");
		PERSON_SCALE = GRID_LENGTH/GRID_SQUARES * 5;
		occupied = new Array(GRID_SQUARES);
		for (var i:Number = 0; i!=GRID_SQUARES; i++) {
			occupied[i] = new Array(GRID_SQUARES);
			for (var j:Number = 0; j!=GRID_SQUARES; j++) occupied[i][j] = false;
		}
		if (initPeople > GRID_SQUARES*GRID_SQUARES || initIll+initImmune > initPeople 
			|| incubationPeriod > days ) attachMovie("errorText","errorText",getNextHighestDepth());
		else init();
	}
	
	private function init():Void {
		//Draw the initial grid.
		drawGrid(GRID_LENGTH,GRID_SQUARES);
		//Add the people.
		attachPeople(initPeople,initIll,initImmune);
	}
	
	//Draw grid.
	private function drawGrid(side:Number,squares:Number) {
		createEmptyMovieClip("grid",getNextHighestDepth());
		this["grid"].lineStyle(1,0x000000,20); 
		for (var i:Number = 0; i!=squares+1; i++) {
			this["grid"].moveTo(i*side/squares,0);
			this["grid"].lineTo(i*side/squares,side);
			this["grid"].moveTo(0,i*side/squares);
			this["grid"].lineTo(side,i*side/squares);
		}
	}
	
	//Attach the people. The first 0<=i<howManyIll can be ill. The next lot can be immune.
	private function attachPeople(howMany:Number,howManyIll:Number,howManyImmune:Number) {
		
		//Attach people randomly. Make temporary array of available
		//positions and remove one by one.
		var available:Array = new Array (GRID_SQUARES*GRID_SQUARES);
		for (var i:Number = 0; i!= available.length; i++ ) available[i] = i;
		
		for (var i:Number = 0; i!=howMany; i++ ) {
			var aPerson = attachMovie("Person","person"+i,getNextHighestDepth());
			var rand:Number = Math.floor(Math.random()*available.length);
			//trace("rand = "+rand);
			aPerson._xscale = aPerson._yscale = PERSON_SCALE; 
			aPerson.xgrid = available[rand]%GRID_SQUARES;
			aPerson.ygrid = (available[rand]-aPerson.xgrid)/GRID_SQUARES;
			aPerson._x=aPerson.xgrid * GRID_LENGTH/GRID_SQUARES;
			aPerson._y=aPerson.ygrid * GRID_LENGTH/GRID_SQUARES;
			occupied[aPerson.xgrid][aPerson.ygrid] = true;
			available.splice(rand,1);
			//trace("available.length = "+available.length);
			//Hide isolation box.
			aPerson.isolationBox._visible = false;
			//trace(aPerson);
			if (i<howManyIll) {
				aPerson.neverGotIll = false;
				aPerson.state = "ILL";
				if (incubationPeriod == 0 && behaviourIfIll == "isolation") aPerson.gotoAndStop(4);
				else aPerson.gotoAndStop(2);
				aPerson.illCount=0;
			} else if (i<howManyIll+howManyImmune) {
				aPerson.gotoAndStop(3);
				aPerson.state = "IMMUNE";
			}
			
			
		}	
	}
	
	private function oneDay() {
		
		//Array stores position of ill people at end of movement stage.
		var illPeople:Array = [];
		
		//trace("function oneDay() has been called");
		for (var i:Number = 0; i!=initPeople; i++) { 
			
			//Increment illCount if ill.
			if (this["person"+i].illCount != -1) this["person"+i].illCount++;
			
			//Maybe person dies now.
			if (this["person"+i].illCount==days) {
				if (Math.random() < probDie) {
					//trace("A DEATH SHOULD HAPPEN NOW");
					this["person"+i]._visible=false;
					this["person"+i].state = "DEAD";
					occupied[this["person"+i].xgrid][this["person"+i].ygrid] = false;
					this["person"+i].xgrid=this["person"+i].ygrid=-2;
				} else {
					this["person"+i].illCount=-1;
					this["person"+i].gotIllAndRecovered = true;
					if (immunity) {
						this["person"+i].state = "IMMUNE";
						this["person"+i].gotoAndStop(3);
					} else {
						this["person"+i].state = "FINE";
						this["person"+i].gotoAndStop(1);
					}
				}	
			}
			
			//Do we keep or remove isolation box?
			if (this["person"+i].illCount > incubationPeriod && behaviourIfIll == "isolation")	{ 
				this["person"+i].gotoAndStop(4);
				//trace("INSIDE");
			}

		    //Determine movement of person.
			//trace("item 1 state " +this["person"+i].state);
			//trace("item 2 state "+this["person"+i].illCount);
			//trace("item 3 state "+incubationPeriod);
			//trace("item 4 state "+behaviourIfIll);
			if ( (this["person"+i].state != "DEAD" && this["person"+i].illCount <= incubationPeriod)
			    || (this["person"+i].illCount > incubationPeriod &&
				     behaviourIfIll == "normal") ) {
				var p:Number = Math.random();
				//trace("p = "+p);
				//Only move if p>probStay.
				if (p <= 1-probStay) {
					//Grid co-ords of new point to move to.
					var xnew:Number=this["person"+i].xgrid; var ynew:Number=this["person"+i].ygrid;
					var q:Number = (1-probStay)/8;
					//trace("xnew = "+xnew);
					//trace("ynew = "+ynew);
					//trace("q = "+q);
					
					var cAse:Number;
					//New co-ordinates.
					if (0<=p && p<q) {cAse=0; xnew--; ynew--;}
					else if (q<=p && p<2*q) {cAse=1; ynew--;}
					else if (2*q<=p && p<3*q) {cAse=2; xnew++; ynew--;}
					else if (3*q<=p && p<4*q) {cAse=3; xnew++; }
					else if (4*q<=p && p<5*q) {cAse=4; xnew++; ynew++;}
					else if (5*q<=p && p<6*q) {cAse=5; ynew++;}
					else if (6*q<=p && p<7*q) {cAse=6; xnew--; ynew++;}
					else if (7*q<=p && p<8*q) {cAse=7; xnew--; }
					
					//trace("xnew = "+xnew);
					//trace("ynew = "+ynew);
					
					
					//Swap to reflected co-ords if at a wall.
					if (xnew<0 || xnew>=GRID_SQUARES || ynew<0 || ynew>=GRID_SQUARES){
						if (cAse==0) {xnew+=2; ynew+=2;}
						else if (cAse==1) {ynew+=2;}
						else if (cAse==2) {xnew-=2; ynew+=2;}
						else if (cAse==3) {xnew-=2;}
						else if (cAse==4) {xnew-=2; ynew-=2;}
						else if (cAse==5) {ynew-=2;}
						else if (cAse==6) {xnew+=2; ynew-=2;}
						else if (cAse==7) {xnew+=2; }	
					}
					
					//trace("occupied? "+occupied[xnew][ynew]);
					//Only move if (xnew,ynew) on grid and nobody in the place.
					if ( !(xnew<0 || xnew>=GRID_SQUARES || ynew<0 || ynew>=GRID_SQUARES)
						  && !occupied[xnew][ynew] ){
						occupied[this["person"+i].xgrid][this["person"+i].ygrid]=false;
						occupied[xnew][ynew] = true;
						this["person"+i].xgrid = xnew;
						this["person"+i].ygrid = ynew;
						this["person"+i]._x = xnew * GRID_LENGTH/GRID_SQUARES;
						this["person"+i]._y = ynew * GRID_LENGTH/GRID_SQUARES;
					}
				}				
			}
			
			//trace("person "+i+" state: "+this["person"+i].state);
			//Store person temporarily in array if ill.
			if (this["person"+i].state == "ILL") illPeople.push(i);
		}
		
		//trace("Ill people: "+illPeople);
		currentIll = illPeople.length;
		
		//Now for disease contraction only for fine people.
		for (var i:Number = 0; i!=initPeople; i++){
			if (this["person"+i].state == "FINE") {
				var mc:MovieClip = this["person"+i];
				
				var xNear:Number = mc.xgrid;
				var yNear:Number = mc.ygrid;
				
				//If next to an ill person then contract illness possibly.
				for (var j:Number = 0; j!=illPeople.length; j++) 
				if ( ( (mc.xgrid-this["person"+illPeople[j]].xgrid)*
					   (mc.xgrid-this["person"+illPeople[j]].xgrid)+
					   (mc.ygrid-this["person"+illPeople[j]].ygrid)*
					   (mc.ygrid-this["person"+illPeople[j]].ygrid) < 3 )  
					&& (Math.random() < probContract) 
					&& (this["person"+illPeople[j]]._currentFrame != 4) ) {
					mc.illCount = 0;
					mc.gotoAndStop(2);
					mc.state = "ILL";
					mc.neverGotIll = false;
				}
			}
		}
		
		//Count up numbers.
		neverGotIll = 0; gotIllAndRecovered = 0; dead = 0;
		for (var i:Number = 0; i<initPeople; i++) {
			if(this["person"+i].state == "DEAD") dead++;
			if (this["person"+i].neverGotIll) neverGotIll++;
			if (this["person"+i].gotIllAndRecovered) gotIllAndRecovered++;
		}
		//trace("gotIllAndRecovered "+ gotIllAndRecovered);
		
		//Lose the ill list.
		delete illPeople;
		
	}
	
	
}