﻿class TreeDiagram extends mx.core.View {
	
	static var WIDTH:Number = 210; //Width of whole tree diagram.
	static var HEIGHT:Number = 270; //Height of tree diagram.
	var STAGES:Number = 20; //Number of left/right turns in a path. 
	static var xCUSHION:Number = 5; //Padding to put diagram in right x place.
	static var yCUSHION:Number = 33; //Padding to put diagram in right y place.
	
	var pathDown:Number = 0;
	var pathAcross:Number = 0;
	
	function TreeDiagram() {
	}
	
	function init():Void {
		//Set initial tree tab.
		//this["spinnerSizes"].selectedIndex = 40;
		//trace("list is = "+this["treeSizes"]);
		//trace("selected index = "+this["spinnerSizes"].selectedIndex);
		//trace("selectedItem = "+this["treeSizes"].selectedItem.label);
		
		trace("Here we are init!");
		
		//Draw the tree.
		drawStructure(STAGES); 
		
		//New tree instructions.
		//var oListener:Object = new Object();                  LOST
		//oListener.click = function(oEvent:Object):Void {		LOST
		this["newTree"].onPress = function() {
			//var mc:MovieClip = oEvent.target._parent;         LOST
			var mc:MovieClip = this._parent;
			
			trace("here we go " + mc.treeSizes.selectedItem.label);
			
			//Delete old tree.
			mc.structure.removeMovieClip();
			mc.path.removeMovieClip();
			mc.pathDown = 0;
			mc.pathAcross = 0;

			//Create new tree.
			mc.STAGES = Number(mc.treeSizes.selectedItem.label);
			mc.drawStructure(mc.STAGES);
			mc.drawPath();
		};
		//this["newTree"].addEventListener("click",oListener);
		
		trace("drawPath about to be called");
		//Prepare, rather than draw, path.
		drawPath();
	}
	
	
	
	//Draw the structure.
	function drawStructure(stages:Number):Void { 
		createEmptyMovieClip("structure",getNextHighestDepth());
		var mc = this["structure"];
		mc.createEmptyMovieClip("network",mc.getNextHigestDepth());
		//trace("Here we go: "+mc);
		
		var c:Number = xCUSHION;
		var d:Number = yCUSHION;
		mc.network.lineStyle(1.5,0x000000,100);
		mc.attachMovie("disc","disc0-0",mc.getNextHighestDepth(),{_x:c+WIDTH/2,_y:d});
		mc.network.moveTo(c,d+HEIGHT/stages);
		mc.network.lineTo(c+WIDTH/2,d);
		mc.network.lineTo(c+WIDTH,d+HEIGHT/stages);
		for (var i:Number=1; i!=stages; i++) {
			for (var j:Number=0; j!=i+1; j++) {
				if (i!=stages-1) {
					mc.network.moveTo(c+(j+1)*WIDTH/(i+1),d+(i+1)*HEIGHT/stages);
					mc.network.lineTo(c+j*WIDTH/i,d+i*HEIGHT/stages);
					mc.network.lineTo(c+j*WIDTH/(i+1),d+(i+1)*HEIGHT/stages);
				}
				mc.attachMovie("disc","disc"+i+"-"+j,mc.getNextHighestDepth(),
				{_x:c+j*WIDTH/i,_y:d+i*HEIGHT/stages});

			}
		}		
	
	}
	
	function drawPath():Void {
		createEmptyMovieClip("path",getNextHighestDepth());
		this["path"].lineStyle(4,0x6600ff,100);
		this["path"].moveTo(xCUSHION+WIDTH/2,yCUSHION+0); 
	}
	
	function drawSegment(bool:Boolean):Void {
		if (pathDown < STAGES-1) {
			trace("pathDown ="+pathDown);
			trace("STAGES ="+STAGES);
			
			this["path"].lineStyle(4,0x6600ff,100);
			if (bool) pathAcross++;
			this["path"].lineTo(xCUSHION+pathAcross*WIDTH/(pathDown+1),yCUSHION+(pathDown+1)*HEIGHT/STAGES);
			//this["path"].lineTo(xCUSHION+pathDown*WIDTH/(pathAcross+1),yCUSHION+(pathAcross+1)*HEIGHT/STAGES);
			pathDown++;
		}
	}
		
	
	//Get rid of path.
	function removePath():Void { this["path"].removeMovieClip() };
	
}