﻿class Spinners extends BaseExperiment implements Experiment {
	
	//No more than 10 as usual.
	private var spinnerCount:Number = 0;
	var inMotion:Boolean = false;
	
	static var MAX_SPINNERS:Number = 4;
	
	function Spinners() {
	}
	
	function init():Void {
		//Do we need this statement? Yes, do the BaseExperiment init first, that's what it means.
		super.init();
		
		//trace(this["spinnerSizes"]);
		
		//Why doesn't oListener stuff work? Replacing with onPress
		//var oListener:Object = new Object();
		//oListener.click = function(oEvent:Object):Void {
		this["newSpinner"].onPress = function() {	
			if (this._parent.spinnerCount < MAX_SPINNERS) {
				//var mc:MovieClip = oEvent.target._parent;
				var mc:MovieClip = this._parent;

				var aSpinner = Spinner(mc.attachMovie("Spinner","spinner"+mc.spinnerCount,
					mc.getNextHighestDepth(),{nSlots:Number(mc.spinnerSizes.selectedItem.label)}));
				aSpinner._y = 120
				aSpinner._x = 40 + (mc.spinnerCount % 10)*70;
				mc.spinnerCount++;
				aSpinner._xscale = aSpinner._yscale = 35;
				//trace("How many? "+ aSpinner);
			}
		};
		
		this["deleteSpinners"].onPress = function() {	
			for (var i:Number = 0; i!=this._parent.spinnerCount; i++ )
				this._parent["spinner"+i].removeMovieClip();
			this._parent.spinnerCount = 0;	
		};
		
	}
	
	public function runOnce():Object {
		
		//If no spinners then nothing happens.
		if (spinnerCount==0) return null;
		
		//trace("here in runOnce");
		var obj:Object = new Object();
		obj.resultString = " ";
		var sum:Number = 0;
		if (!inMotion) {
			//Next line not necessary? Just set inMotion = true;
			inMotion = (spinnerCount==0) ? false : true;
			for (var i:Number = 0; i!=spinnerCount; i++) {
				var n:Number = this["spinner"+i].spin(1.5);
				obj.resultString += n + "\t";
				//trace(_parent["spinner"+i].spin(5));
				sum += n;
			}
			for (var i:Number = 0; i!=MAX_SPINNERS-spinnerCount; i++)
				obj.resultString += "\t";
			
			obj.resultString += "\t" + sum;
			
							
				//Update frequency table. Lazy coding.
				//trace("Unlikely :"+this._parent._parent.results.frequency);
				this._parent._parent.results.frequency.record[sum]++;
			
			return obj;
		} else return null;
	}
	
	// Run the experiment fast with minimal or no animation
	function runFast():Object {
		
		//If no spinners then nothing happens.
		if (spinnerCount==0) return null;

		
		var obj:Object = new Object();
		obj.resultString = " ";
		var sum:Number = 0;
		for (var i:Number = 0; i!=spinnerCount; i++) {
			var n:Number =  this["spinner"+i].entry[Math.floor(Math.random()*this["spinner"+i].nSlots)];
			obj.resultString += n + "\t";
			sum+=n;
		}
		for (var i:Number = 0; i!=MAX_SPINNERS-spinnerCount; i++)
			obj.resultString += "\t";
		obj.resultString += "\t" + sum;
		//trace("resultString "+obj.resultString);
		this._parent._parent.results.frequency.record[sum]++;
		//trace("sum="+sum);
		return obj;
	}
	
	function getScore(result:Object):Number {
		return result.resultString;
		/*
		if(obj==6)
			return 1;
		else
			return 0;
		*/
	}
}