﻿class Probaballs extends BaseExperiment implements Experiment {
	
	var slotState:Number = 3;
	//No more than 10 balls.
	var ballCount:Number = 0;
	//-1 if unoccupied, otherwise takes value n of ball n that occupies it
	var holeOccupied:Array;
	
	function Probaballs() {
		//init();
	}
	
	//Note init functions get called automatically. I never knew that.
	function init():Void {
		
		//No holes occupied initially.
		holeOccupied = new Array(3);
		for (var i:Number =0; i!=3; i++) holeOccupied[i] = -1;
		
		//Make two sets of slots invisible.
		this["slots3"]._visible = true;
		this["slots6"]._visible = false;
		this["slots7"]._visible = false;
		
		//Change slots button.
		this["changeHoles"].onPress = function() { 
		
			var tp = this._parent;
			
			tp.changeSlots(); 
		
			//Clear everything.
			for (var i:Number = 0; i!=tp.ballCount; i++)
				tp["ball"+i].removeMovieClip();
				tp.ballCount = 0;
				tp.holeOccupied = new Array(tp.slotState);
			for (var i:Number =0; i!=tp.slotState; i++)  tp.holeOccupied[i] = -1;
		
		
		};
		
		//Introduce new ball button.
		this["newBall"].onPress = function() {
			if (this._parent.ballCount < 10) {
			
				//Save me writing this._parent a lot of times.
				var tp = this._parent;
			
				//Attach ball of a certain colour.
				if (tp.colours.selectedItem.label == "red") {
					var b = tp.attachMovie("redBall","ball"+tp.ballCount,tp.getNextHighestDepth());
					b.colour = "red";
				}
				else if (tp.colours.selectedItem.label == "blue") {
					var b = tp.attachMovie("blueBall","ball"+tp.ballCount,tp.getNextHighestDepth());
					b.colour = "blue";
				}
				else if (tp.colours.selectedItem.label == "green") {
					var b = tp.attachMovie("greenBall","ball"+tp.ballCount,tp.getNextHighestDepth());
					b.colour = "green";
				}
				else if (tp.colours.selectedItem.label == "yellow") {
					var b = tp.attachMovie("yellowBall","ball"+tp.ballCount,tp.getNextHighestDepth());
					b.colour = "yellow";
				}
			
				//Increase ball count and position ball.
				b._x = 135 + (this._parent.ballCount % 10)*14; 
				b._y = 33;
				this._parent.ballCount++;

			
				//Ball is not currently in a hole. Positive number if in a hole
				b.inHole = -1;
			
			
				//Drag it on press.
				b.onPress = function() {
					//No longer in a hole.
					if (b.inHole != -1) {
						//trace("hole"+ b.inHole);
						this._parent.holeOccupied[b.inHole] = -1;
						b.inHole = -1;
					}
					this.startDrag(); 
				};
			
				//On release stopdrag and vanish if not over hole.
				b.onRelease = function() {
					this.stopDrag();
				
					var I = this._parent.overHole(this);
					if (I == -1) {
						//this.removeMovieClip();
					} else { 
						//Locate ball neatly within hole.
						b._x = this._parent["slots"+this._parent.slotState]["hole"+I]._x+
							   this._parent["slots"+this._parent.slotState]._x;
						b._y = this._parent["slots"+this._parent.slotState]["hole"+I]._y+
						       this._parent["slots"+this._parent.slotState]._y;
						//Hole is now full.
						this._parent.holeOccupied[I] = Number(b._name.substr(4,1));
						trace("b.name.substr = " + Number(b._name.substr(4,1)) );
						b.inHole = I;
					}
				};
				
		 	}
		 };
		
	}
	
	private function changeSlots():Void {
		switch (slotState) {
			case 3:
				this["slots3"]._visible = false;
				this["slots6"]._visible = true;
				this["slots7"]._visible = false;
				slotState = 6;
				break;
			case 6:
				this["slots3"]._visible = false;
				this["slots6"]._visible = false;
				this["slots7"]._visible = true;
				slotState = 7;
				break;
			case 7:
				this["slots3"]._visible = true;
				this["slots6"]._visible = false;
				this["slots7"]._visible = false;
				slotState = 3;
				break;	
		}
	}
	
	//Tests if ball is over hole. Returns number of hole or -1 if not.
	private function overHole(mov:MovieClip):Number {
		//trace("inside overHole");
		for (var mc in this["slots"+slotState]) {
			var I = Number(mc.substr(4,1));
			
			//trace(mc);
			//trace("I="+I);
			//trace("_xmouse ="+_xmouse);
			//trace("slot thing"+ this["slots"+slotState]);
			//trace("slotsx = "+ this["slots"+slotState]._x);
			//trace(this["slots"+slotState][mc]._x);
			//trace(this["slots3"][mc]);
			//trace(this["slots3"][mc].hitTest(mov));
			//trace(holeOccupied[I]);
			
			var u:Number = this["slots"+slotState][mc]._x;
			var v:Number = this["slots"+slotState][mc]._y;
			
			var s:Number = Number(_xmouse)-Number(this["slots"+slotState]._x);
			var t:Number = Number(_ymouse)-Number(this["slots"+slotState]._y);
			
			//trace("s="+s);
			//trace("t="+t);
			//trace("u="+u);
			//trace("v="+v);
			
			if ( (s-u)*(s-u)+(t-v)*(t-v)< 1000 && holeOccupied[I]==-1)
				{ trace("yeah"); return I; }
		
		//Had trouble with this hitTest on many fronts.
		//	if ( this["slots"+slotState][mc].hitTest(s,t,true) && !holeOccupied[I])
		//		{ trace("yeah"); return I; }
		
		}
		return -1;
	}
	
	
	public function runOnce():Object {
		
		//Only rearrange if have full number of balls.
		var bool:Boolean = true;
		for (var i:Number = 0; i!=slotState; i++) 
			if (holeOccupied[i]==-1) {trace("hole "+i+" is empty"); bool = false;}                        
		if (bool) {
			this.attachMovie("bang","Bang",getNextHighestDepth(),{_x:167,_y:150});
			rearrange();
		}
		
		return null;
	}
	
	public function runFast():Object {
		return null;
	}
	
	private function rearrange():Void {
		//New array of random slotState - tuple.
		var tuple:Array = new Array(slotState);
		
		var temp:Array = new Array(slotState);
		for (var i:Number = 0; i!=slotState; i++) temp[i]=i;
		
		//Random fill tuple.
		for (var i:Number = 0; i!=slotState; i++) {
			var n:Number = Math.floor(Math.random()*(slotState-i))
			tuple[i] = temp[n];
			temp.splice(n,1);
		}
		//trace(tuple);
		
		//Now move the balls around.
		for (var i:Number = 0; i!=slotState; i++) {
			var b = this["ball"+holeOccupied[i]];
			trace("Ball b is " + b._name);
			b._x = this["slots"+slotState]["hole"+tuple[i]]._x+this["slots"+slotState]._x;
			b._y = this["slots"+slotState]["hole"+tuple[i]]._y+this["slots"+slotState]._y;
			b.inHole = tuple[i];
		}
		
	}
}