﻿import mx.core.View;
import BaseExperiment;
import Experiment;
import ConfiguredExperiment;
import RedCorners;
//import CoinToss;
//import CubicDie;
import ScrolledLogger;
//
// gui.as
//
var experiment:Experiment;
//
// Initialise accordion listener
//
var	accListener:Object = new Object();
accListener.change = function(evt) {
	View(evt.target.getChildAt(evt.prevValue)).init();
	View(evt.target.selectedChild).init();
	View(results.selectedChild).init();
	results.selectedChild.clear();
};
//
// Initialise results listener
//
/*
var	resultsListener:Object = new Object();
resultsListener.change = function(evt) {
	View(evt.target.getChildAt(evt.prevValue)).init();
	View(evt.target.selectedChild).init();
};
*/

function initAccordion(config:Config) {
	// Insert coin toss instance
	//accordion.createChild("CoinToss", "coinToss", {label:"Coin Toss"});
	//accordion.createChild("CubicDie", "cubicDie", {label:"Cubic Die"});
	if(!config.resultsVisible) {
		accordion.setSize(550,378);
		clear_btn._visible = false;
		lots_btn._visible = false;
		run_btn._x = 245;
	}
	for(var i = 0; i < config.experiments.length; i++) {
		var ex:XMLNode = XMLNode(config.experiments[i]);
		var idRef:String = ex.attributes["idRef"];
		//trace(idRef);
		var name:String = ex.attributes["name"];
		//trace("experiment name: "+name+ " class: "+id);
		accordion.createChild(idRef, name, {label:name, config:config, index:i});
	}
	accordion.addEventListener("change", accListener);
	//trace(accordion.selectedChild);
	View(accordion.selectedChild).init();
	accordion._alpha = 100;
	sum = 0;
	N = 0;
}
//
// Initialise the reports
//
function initResults(config:Config) {
	if(config.resultsVisible) {
		if(config.treeVisible) {
			results.createChild("ScrolledTree","tree",{label: "Lose (red) to left; Win (blue) to right"});
			View(results.tree).init();
		}
		if(config.logVisible) {
			var s:String = "";
			if(config.NVisible) s += "N   ";
			if(config.LabelVisible) s += "| Result ";
			if(config.ScoreVisible) s += "| Score ";
			if(config.SumVisible) s += "|  Sum   ";
			if(config.MeanVisible) s += "|  Mean  ";
			if(config.StdDevVisible) s += "|  Std Dev";
			results.createChild("Logger", "log", {label:s});
			View(results.log).init();
		}
		results.addEventListener("change", resultsListener);
		results._alpha = 70;
	}
	else {
		results._visible = false;
	}
}
//
// run once
//
run_btn.onRelease = function() {
	var e:Experiment=Experiment(this._parent.accordion.selectedChild);
	var obj:Object = e.runOnce();
	if(obj != null) {
		log(e, obj);
		ScrolledLogger(results.log).end();
	}
};
//
// run lots
//
lots_btn.onRelease = function() {
	var e:BaseExperiment=BaseExperiment(this._parent.accordion.selectedChild);
	this._parent.runLots(true);
	ScrolledLogger(results.log).end();
};
var randtime :Number = 0;
function runLots(fast:Boolean) {
	randtime = getTimer();
	randtime -= Math.floor(randtime/1000)*1000;
	randtime /= 1000;
	//
	//trace(randtime);
	//randtime is now a random integer in 0..999
	//
	var e:Experiment=Experiment(accordion.selectedChild);
	for (var i = 0; i<100; i++) {
		runAndLog(e, fast);
	}
}
function trand():Number {
	return Math.random();
	var r:Number = randtime + Math.random();
	r = r > 1 ? r - 1 : r;
	if(r > 1) {
		trace(r);
	}
	//trace(r);
	return r;
}
var sum = 0;
var sum2 = 0;
var N = 0;
clear_btn.onRelease = function() {
	sum = 0;
	sum2 = 0;
	N = 0;
	this._parent.results.log.clear();
	this._parent.results.tree.clear();
	this._parent.results.tree._y = 21;
}
function runAndLog(e:Experiment, fast:Boolean) {
	var obj:Object = fast ? e.runFast() : e.runOnce();
	log(e, obj);
}
function log(e:Experiment, obj:Object) {
	var config:Config = _level0.config;
	var score = e.getScore(obj);
	var label = e.getLabel(obj);
	sum += score;
	var score2 = score * score;
	sum2 += score2;
	N++;
	var mean = sum/N;
	var stddev:Number;
	if(N > 1) {
		var variance = (sum2 - mean*mean*N)/(N-1);
		stddev = Math.sqrt(variance);
	}
	var s:String = "";
	if(config.NVisible) s += numWidth(N, 5);
	if(config.LabelVisible) s += fieldWidth(label, 8);
	if(config.ScoreVisible) s += numWidth(score, 5)+" ";
	if(config.SumVisible) s += numWidth(sum, 5)+" ";
	if(config.MeanVisible) s += numWidth(mean, 7)+ " ";
	if(N > 1) {
		if(config.StdDevVisible) s += numWidth(stddev, 8);
	}
	ScrolledLogger(results.log).append(s+"\n");
	results.tree.drawSegment(label=="Win");
}
function numWidth(n:Number, width:Number):String {
	n = Math.round(n*1000)/1000;
	return fieldWidth(String(n), width);
}
function fieldWidth(s:String, width:Number):String {
	//trace(s.length);
	for(var i = s.length; i < width; i++) {
		s += "  ";
	}
	return s;
}
//
// stop running
//
stop_btn.onRelease = function() {
	var e:BaseExperiment=BaseExperiment(this._parent.accordion.selectedChild);
	e.onEnterFrame = undefined;
};
