﻿class TwoDiscs extends BaseExperiment implements Experiment {
	
	var discs:Array;
	var xcentres:Array;
	var ycentres:Array;
	
	function init():Void {
		super.init();
		discs = [this["disc1"], this["disc2"]];
		xcentres = [discs[0]._x, discs[1]._x];
		ycentres = [discs[0]._y, discs[1]._y];
	}

	public function runOnce():Object {
		var a:Array = [];
		for(var i = 0; i < discs.length; i++) {
			var r = Math.floor(Math.random()*2);
			trace(r);
			discs[i].gotoAndStop(r+1);
			discs[i]._x = xcentres[i]+(Math.random()-0.5)*30;
			discs[i]._y = ycentres[i]+(Math.random()-0.5)*30;
			discs[i]._rotation = Math.random()*90;
			a.push(r);
		}
		return a;
	}
	

	// Run the experiment fast with minimal or no animation
	function runFast():Object {
		
		var a:Array = [];
		for(var i = 0; i < discs.length; i++) {
			var r = Math.floor(Math.random()*2);
			//discs[i].gotoAndStop(r);
			a.push(r);
		}
		return a;
	}
	
	function win(result:Object):Boolean {
		var s:Number = 0;
		//trace(result);
		for(var i = 1; i < result.length; i++) {
			if(result[i] != result[s]) {
				return false;
			}
		}
		return true;
	}
	
	// Convert experimental result objects to useful things
	function getScore(result:Object):Number {
		return win(result) ? 1 : 0;		
	}
	
	// Convert experimental result objects to useful things
	function getLabel(result:Object):String {
		return win(result) ? "Win" : "Lose";		
	}
}
