﻿//import Result;
class Tumbler extends MovieClip {
	var kGravity:Number = 1;
	var gravity:Vector;
	var beads:Array;
	var a:Number = 100;
	var b:Number = 30;
	var c:Number = 3;
	var samplers:Array;
	var sampling:Boolean = false;
	var rTime:Number = 1500;
	var time:Number;
	var holes:Array;
	var emptyHoles:Array = null;
	var bColor:Number = 0xddeeff;
	var lColor:Number = 0xeeeeee;
	var lThickness:Number = 5;
	var settledCount:Number = 0;
	function Tumbler() {
		if(beads == null) {
			beads = new Array();
		}
		for(var i = 0; i < beads.length; i++) {
			beads[i].tumbler = this;
		}
		settledCount = 0;
		gravity = new Vector({x:0,y:kGravity});
		time = getTimer();
		draw();
	}
	function pCurve(theta:Number) {
		return a+b*Math.sin(c*theta);
	}
	function pDeriv(theta:Number) {
		return b*c*theta*Math.cos(c*theta);
	}
	function draw() {
		var x:Number = pCurve(0);
		var y:Number = 0;
		beginFill(bColor);
		lineStyle(lThickness, lColor, 100);
		moveTo(x, y);
		for(var t:Number = 2; t <= 360; t += 2) {
			var theta = t*Math.PI/180;
			var r:Number = pCurve(theta);
			lineTo(r*Math.cos(theta), r*Math.sin(theta));
		}
		endFill();
		for(var i:Number=0; i < beads.length; i++) {
			var b:Bead = Bead(beads[i]);
			b.draw();
		}
	}
	function startAnimation() {
		//trace("start Animation");
		time = getTimer();
		emptyHoles = null;
		for(var i = 0; i < beads.length; i++) {
			var bd:Bead = Bead(beads[i]);
			bd._visible = true;
			bd.vx = 0;
			bd.vy = 2;
		}
		onEnterFrame = frameAnimate;
	}
	function stopAnimation() {
		onEnterFrame = null;
	}
	function frameAnimate() {
		_rotation += 2;
		animate2(1, (_rotation+90)*Math.PI/180);
	}
	function globalXY():Vector {
		var p:Object = {x:_x, y:_y};
		_parent.localToGlobal(p);
		return new Vector(p);
	}
	//
	//
	//
	function animate2(dt:Number, theta:Number) {
		if((emptyHoles == null) && (getTimer() - time > rTime*(0.8+0.4*Math.random()))) {
			emptyHoles = holes.concat();
			for(var i = 0; i < emptyHoles.length; i++) {
				var h:Hole = Hole(emptyHoles[i]);
				h.bead = null;
			}
			for(var i = 0; i < beads.length; i++) {
				var bd:Bead = Bead(beads[i]);
				bd.holed = false;
			}
		}
		var r = Math.floor(Math.random()*beads.length);
		for(var i = 0; i < beads.length; i++) {
			var j = (r + i) % beads.length;
			//trace(j);
			beads[j].move2(dt, theta, emptyHoles);
		}
	}
}