﻿class TreeDiagram extends mx.core.View {
	
	static var WIDTH:Number = 226; //Width of whole tree diagram.
	static var HEIGHT:Number = 290; //Height of tree diagram.
	static var STAGES:Number = 50; //Number of left/right turns in a path. 
	static var xCUSHION:Number = 2; //Padding to put diagram in right x place.
	static var yCUSHION:Number = 20; //Padding to put diagram in right y place.
	
	var pathDown:Number = 0;
	var pathAcross:Number = 0;
	
	function init():Void {

		//Draw the tree.
		drawStructure(STAGES); 
		
		//New tree instructions.
		var oListener:Object = new Object();
		oListener.click = function(oEvent:Object):Void {		
			var mc:MovieClip = oEvent.target._parent;

			//trace("here we go " + mc.treeSizes.selectedItem.label);
			
			//Delete old tree.
			mc.structure.removeMovieClip();
			
			//Create new tree.
			mc.drawStructure(Number(mc.treeSizes.selectedItem.label));
		};
		this["newTree"].addEventListener("click",oListener);
		
		//trace("drawPath about to be called");
		//Prepare, rather than draw, path.
		drawPath();
	}
	
	function clear():Void {
		//trace("CLEAR TREE");
		this["structure"].removeMovieClip();
		removePath();
		drawStructure(STAGES);
		drawPath();
		pathAcross = pathDown = 0;
	}
	
	//Draw the structure.
	function drawStructure(stages:Number):Void { 
		createEmptyMovieClip("structure",getNextHighestDepth());
		var mc = this["structure"];
		mc.createEmptyMovieClip("network",mc.getNextHigestDepth());
		//trace("Here we go: "+mc);
		
		var c:Number = xCUSHION;
		var d:Number = yCUSHION;
		var alpha:Number = 100;
		mc.network.lineStyle(1.5,0x000000,alpha);
		//mc.attachMovie("disc","disc0-0",mc.getNextHighestDepth(),{_alpha:20, _x:c+WIDTH/2,_y:d});
		mc.network.moveTo(c,d+HEIGHT/stages);
		mc.network.lineTo(c+WIDTH/2,d);
		mc.network.lineTo(c+WIDTH,d+HEIGHT/stages);
		for (var i:Number=1; i!=stages; i++) {
			alpha *= 0.92;
			mc.network.lineStyle(1.5,0x000000,alpha);		
			for (var j:Number=0; j!=i+1; j++) {
				if (i!=stages-1) {
					mc.network.moveTo(c+(j+1)*WIDTH/(i+1),d+(i+1)*HEIGHT/stages);
					mc.network.lineTo(c+j*WIDTH/i,d+i*HEIGHT/stages);
					mc.network.lineTo(c+j*WIDTH/(i+1),d+(i+1)*HEIGHT/stages);
				}
				//mc.attachMovie("disc","disc"+i+"-"+j,mc.getNextHighestDepth(),
				//{_x:c+j*WIDTH/i,_y:d+i*HEIGHT/stages});

			}
		}		
	
	}
	
	function drawPath():Void {
		createEmptyMovieClip("path",1000);
		this["path"].lineStyle(4,0x6600ff,100);
		this["path"].moveTo(xCUSHION+WIDTH/2,yCUSHION+0); 
	}
	
	function drawSegment(bool:Boolean):Void {
		var color:Number = bool ? 0x8888ff : 0xff8888;
		this["path"].lineStyle(3,color,100);
		if (bool) pathAcross++;
		this["path"].lineTo(xCUSHION+pathAcross*WIDTH/(pathDown+1),yCUSHION+(pathDown+1)*HEIGHT/STAGES);
		pathDown++;
	}
		
	
	//Get rid of path.
	function removePath():Void { this["path"].removeMovieClip() };
	/*
	function onPress() {
		this.startDrag(false, 0,yCUSHION-_height+360,0,21+yCUSHION);
	}

	function onRelease() {
		this.stopDrag();
	}
	function onReleaseOutside() {
		this.stopDrag();
	}
	*/
}