﻿import BaseExperiment;
import Bead;
import Config;
import Experiment;
import Tumbler;
import ConfiguredExperiment;
class DiscFlip extends ConfiguredExperiment implements Experiment {
	//
	// Result
	//
	function same(holes:Object):Boolean {
		var id = holes[0].bead.idref;
		for(var i = 1; i < holes.length; i++) {
			if(holes[i].bead.idref != id) {
				return false;
			}
		}
		return true;
	}
	function done():Void {
		getScore = function(holes:Object):Number {
			if(same(holes)) {
				return 1;
			}
			else {
				return 0;
			}
		}
		getLabel = function(holes:Object):String {
			if(same(holes)) {
				return "Win";
			}
			else {
				return "Lose";
			}
		}
		_level0.log(this, holes);
	}
	//
	// Run the experiment fast with minimal or no animation
	//
	function runFast():Object {
		getScore = function(s:Object):Number {
			return (s=="Win" ? 1 : 0);
		}
		getLabel = function(s:String):String {
			return s;
		}
		var w:Boolean = Math.random() < 0.5;
		for(var i=1; i < holes.length; i++) {
			var x = Math.random() < 0.5;
			if(x != w) {
				return "Lose";
			}
		}
		return "Win";
	}
}