﻿import BaseExperiment;
import Bead;
import Config;
import Experiment;
import Tumbler;
class ConfiguredExperiment extends BaseExperiment implements Experiment {
	var config:Config;
	var index:Number;
	var beads:Array;
	var holes:Array;
	var tumbler:Tumbler;
	var tumblerBase:Number = 100
	var holeBase:Number = 200;
	var beadBase:Number = 300;
	var kCollisionDamp:Number = 1;
	var kDamp:Number = 1;
	var gravity:Number = 1;
	var rTime:Number = 1500;
	var replacement:Boolean = false;
	var moveAlpha:Number = 100;
	var frozens:Array = null;
	var name:String = "<undefined>";
	var repText:TextField;
	function init():Void {
		//trace("CONFIGURED EXPERIMENT: "+radius);
		reset();
		frozens = [];
		beads = [];
		holes = [];
		var experiment:XMLNode = config.experiments[index];
		if(experiment == null) {
			trace("Experiment["+index+"] not found");
			return;
		}
		kCollisionDamp = Number(experiment.attributes["kCollisionDamp"]);
		kDamp = Number(experiment.attributes["kDamp"]);
		gravity = Number(experiment.attributes["gravity"]);
		rTime = Number(experiment.attributes["rTime"]);
		moveAlpha = Number(experiment.attributes["moveAlpha"]);
		replacement = (experiment.attributes["replacement"] == "true");
		createTextField("replaceText", 15000, 20, 20, 200, 40);
		var tf:TextFormat = new TextFormat();
		tf.font = "_sans";
		tf.color = 0x888888;
		repText = this["replaceText"];
		repText.text = replacement ? "Replacing" : "";
		repText.setTextFormat(tf);
		//trace(gravity);
		//trace(experiment["tumblers"].length);
		var d:Number = tumblerBase;
		for(var idRef:String in experiment["tumblers"]) {
			var tConfig:Object = experiment["tumblers"][idRef];
			//trace("a = "+tConfig.a);
			//trace("b = "+tConfig.b);
			//trace("c = "+tConfig.c);
			//trace("x = "+tConfig.x);
			//trace("y = "+tConfig.y);
			//trace("scale = "+tConfig.scale);
			//
			// Make the beads
			//
			for(var i = 0; i < tConfig.beads.length; i++) {
				var db:Number = beadBase + i;
				if(beads == null) {
					beads = [];
				}
				var bConfig = tConfig.beads[i];
				bConfig.frozens = frozens;
				bConfig.replacement = replacement;
				if(tConfig.holes.length < tConfig.beads.length) {
					bConfig._x = 0;
				}
				beads[i] = Bead(attachMovie((bConfig.icon == null ? "Bead" : bConfig.icon), "bead"+db, db, bConfig));
			}
			//
			// Make the holes
			//
			for(var i = 0; i < tConfig.holes.length; i++) {
				var dh:Number = holeBase + i;
				if(holes == null) {
					holes = [];
				}
				holes[i] = Hole(attachMovie("Hole1", "hole"+dh, dh, tConfig.holes[i]));
			}
			//
			// Make the tumbler
			//
			tumbler = Tumbler(attachMovie("Tumbler", "tumbler"+d, d, {_x:tConfig.x,_y:tConfig.y, beads:beads, holes:holes, kGravity:gravity, rTime:rTime, a:tConfig.a, b:tConfig.b, c:tConfig.c, lColor:tConfig.lColor, lColor:tConfig.lColor, lThickness:tConfig.lThickness}));
			d++;
			_xscale = tConfig.scale;
			_yscale = tConfig.scale; 
		}
	}
	//
	// Result
	//
	function done():Void {
		switch(_name) {
			case "Red Corners" :
				getScore = function(holes:Object):Number {
					//trace(holes[0].bead.idref);
					//trace(holes[2].bead.idref);
					//trace(holes[5].bead.idref);
					if(holes[0].bead.idref=="Red" 
					&& holes[2].bead.idref=="Red" 
					&& holes[5].bead.idref=="Red") {
						return 1;
					}
					else {
						return 0;
					}
				}
				getLabel = function(holes:Object):Number {
					var s="";
					for(var i = 0; i < holes.length; i++) {
						s += holes[i].bead.idref.substr(0,1);
					}
					return s;
				}
			_level0.log(this, holes);
			break;
		}
	}
	function reset():Void {
		if(frozens != null) {
			var f:MovieClip;
			while(f=MovieClip(frozens.pop())) {
				//trace("removing frozens");
				f.removeMovieClip();
			}
		}
		frozens = [];
		tumbler.settledCount = 0;
		for(var i = 0; i < beads.length; i++) {
			var bd:Bead = Bead(beads[i]);
			bd._alpha = moveAlpha;
			bd._visible = true;
			bd.holed=false;
			bd.frozens = frozens;
		}
		for(var i:Number = 0; i < holes.length; i++) {
			var h:Hole = Hole(holes[i]);
			if(h.bead != null) {
				h.bead._x = h._x - h.bead._parent._x;
				h.bead._y = h._y - h.bead._parent._y;
				h.ibead = null;
				h.bead = null;
			}
		}
	}
	function runOnce():Object {
		reset();
		tumbler.startAnimation();
		return null;
	}
	//
	// Run the experiment fast with minimal or no animation
	//
	function runFast():Object {
		switch(_name) {
			case "Red Corners":
			getScore = function(s:Object):Number {
				if(s.substr(0,1)=="R" && s.substr(2,1)=="R" && s.substr(5,1)=="R") {
					return 1;
				}
				else {
					return 0;
				}
			}
			getLabel = function(s:String):String {
				return s;
			}
			var s:String="";
			var u:Array=["R","R","R","B","B","Y"];
			while(u.length > 0) {
				var i = Math.floor(u.length*Math.random());
				var t = u.splice(i,1)[0];
				//trace(t);
				s += t;
			}
			break;
		}
		return s;
	}
	function resetScores():Void {
		trace("foo");
	}
}
