﻿import BaseExperiment;
import Bead;
import Config;
import Experiment;
import Tumbler;
import ConfiguredExperiment;
class BlueTouch extends ConfiguredExperiment implements Experiment {
	var ttests:Array;
	function BlueTouch() {
		ttests = [
				   [1,2,3],
				   [3,4],
				   [3,5],
				   [4,5,6],
				   [6],
				   [6]
				   ];
	}
	//
	// Result
	//
	function bluesTouching(holes:Object):Boolean {
		for(var i = 0; i < ttests.length; i++) {
			var h1:Hole = Hole(holes[i]);
			if(h1.bead.name != "B") {
				continue;
			}
			var touches = ttests[i];
			for(var j = 0; j < touches.length; j++) {
				var h2:Hole = Hole(holes[touches[j]]);
				if(h2.bead.name == "B") {
					return true;
				}
			}
		}
		return false;
	}
	function fastTouch(holes:Object):Boolean {
		for(var i = 0; i < ttests.length; i++) {
			var h1:Hole = holes[i];
			if(h1 != "B") {
				continue;
			}
			var touches = ttests[i];
			for(var j = 0; j < touches.length; j++) {
				var h2:Hole = holes[touches[j]];
				if(h2 == "B") {
					return true;
				}
			}
		}
		return false;
	}
	function done():Void {
		getScore = function(holes:Object):Number {
			if(bluesTouching(holes)) {
				return 1;
			}
			else {
				return 0;
			}
		}
		getLabel = function(holes:Object):String {
			if(bluesTouching(holes)) {
				return "Win";
			}
			else {
				return "Lose";
			}
		}
		_level0.log(this, holes);
	}
	//
	// Run the experiment fast with minimal or no animation
	//
	function runFast():Object {
		getScore = function(s:Object):Number {
			if(fastTouch(s)) {
				return 1;
			}
			else {
				return 0;
			}
		}
		getLabel = function(s:String):String {
			if(fastTouch(s)) {
				return "Win";
			}
			else {
				return "Lose";
			}
			return s;
		}
		var h:Array=[];
		var u:Array=["Y","Y","Y","Y","B","B","R"];
		while(u.length > 0) {
			var i = Math.floor(u.length*_level0.trand());
			h.push(u.splice(i,1)[0]);
		}
		//trace(h);
		return h;
	}
}