﻿class Primes {
	private static var cache:Array;
	public static function at(n:Number):Number {
		if (cache == null) {
			cache = new Array();
			cache[0] = 1;
			cache[1] = 2;
			cache[2] = 3;
			cache[3] = 5;
			cache[4] = 7;
			cache[5] = 11;
			cache[6] = 13;
			cache[7] = 17;
			cache[8] = 19;
			cache[9] = 23;
			cache[10] = 29;
			cache[11] = 31;
		}
		if (cache[n] != null) {
			return cache[n];
		}
		// First estimate the nth prime
		var est:Number;
		est = (n)*(Math.log(n)+Math.log(Math.log(n)));
		//for (var e = est+1; e<100000; e++) {
		for (var poss = cache[cache.length-1]+2; poss<=est; poss += 2) {
			//trace("poss="+poss);
			var isPrime = true;
			for (var i = 2; i<cache.length; i++) {
				var p = cache[i];
				if (p*p>poss) {
					break;
				}
				if (poss/p == Math.floor(poss/p)) {
					isPrime = false;
					break;
				}
			}
			if (!isPrime) {
				continue;
			}
			cache.push(poss);
		}
		if (cache[n] != null) {
			//trace("n="+n+" est="+est+" p[n]="+cache[n]+"p["+(cache.length-1)+"]="+cache[cache.length-1]);
			return cache[n];
		}
		//}
		// should not get here
		return -1;
	}
	static var _weights:Array;
	static var _weightSum:Number = 0;
	static var _maxProduct:Number = 0;
	public static function logbase(b:Number, x:Number):Number {
		return Math.log(x)/Math.log(b);
	}
	public static function random(maxProduct:Number, maxIndex:Number):Number {
		if (_maxProduct != maxProduct) {
			_maxProduct = maxProduct;
			_weights = new Array();
			_weightSum = 0;
			for (var i = 1; i<=maxIndex; i++) {
				_weights[i] = logbase(at(i),maxProduct);//maxProduct/at(i);
				_weightSum += _weights[i];
			}
		}
		var rand = _weightSum*Math.random();
		var sum = 0;
		for (var i = 1; i<=maxIndex; i++) {
			sum += _weights[i];
			if (rand<=sum) {
				return at(i);
			}
		}
		trace("Prime.random() shouldn't get here");
		return at(1);
	}
	public static function isAPrime(n:Number):Boolean {
		var i:Number = 0;
		while(Primes.at(++i) <= n) {
			if(cache[i] == n)
				return true;
		}
		return false;
	}
}
