﻿class RoundCorner {
	static var asteps:Number = 6;
	static var radius:Number = 10;
	static var myAngle:Number = 0;
	static var idAlloc:Number = 0;
	var id:Number=0;
	var _mc:MovieClip;
	var _x:Number;
	var _y:Number;
	//var _label:MovieClip;
	function RoundCorner(mc:MovieClip, x:Number, y:Number) {
		_x = x;
		_y = y;
		if(_x == undefined || _y == undefined) {
			trace("UNDEFINED RoundCorner");
		}
		_mc = mc;
		id = idAlloc++;
		//_label = mc.attachMovie("Label", "text", _level0.depth++);
		//_label._x = x;
		//_label._y = y;
		//_label.label.text = id;
	}
	function bearing(rc:RoundCorner):Number {
		var dx = rc._x-_x;
		var dy = rc._y-_y;
		return Math.atan2(dy, dx);
	}
	function drawRound():Void {
		var steps = 12;
		_mc.moveTo(_x+radius, _y);
		for (var i = 0; i<steps; i++) {
			var a = 2*Math.PI/steps;
			_mc.lineTo(_x+radius*Math.cos(a), _y+radius*Math.sin(a));
		}
	}
	function startDrawingWith(rot:Number) {
		var p:Object = rotatePoint(_x, _y, _x+radius, _y, rot-Math.PI/2);
		_mc.moveTo(p.x, p.y);
	}
	function drawTo(rot:Number, rc:RoundCorner, last:Boolean):Number {
		//trace("drawTo("+rot+",("+rc._x+","+rc._y+"), "+last);
		var dx = rc._x-_x;
		var dy = rc._y-_y;
		var bearing = Math.atan2(dy, dx);
		var range = Math.sqrt(dx*dx+dy*dy);
		myAngle = bearing-rot;
		if (myAngle<0) {
			myAngle += Math.PI*2;
		}
		//trace(_mc + ".moveTo("+p.x+","+p.y+")");
		var astep = myAngle/asteps;
		var a:Number = 0;
		var p:Object;
		for (var i = 0; i<asteps; i++) {
			a += astep;
			p = rotatePoint(_x, _y, _x+radius, _y, rot+a-Math.PI/2);
			_mc.lineTo(p.x, p.y);
			//trace(_mc + ".lineTo("+p.x+","+p.y+")");
			//trace(radius*Math.cos(a)+","+(radius*Math.sin(a)));
		}
		if (!last) {
			p = rotatePoint(rc._x, rc._y, rc._x+radius, rc._y, bearing-Math.PI/2);
			_mc.lineTo(p.x, p.y);
			//trace(_mc + ".lineTo("+p.x+","+p.y+")");
		}
		return bearing;
	}
	function rotatePoint(cx, cy, x, y, angle):Object {
		var xp = x-cx;
		var yp = y-cy;
		x = cx+xp*Math.cos(angle)-yp*Math.sin(angle);
		y = cy+xp*Math.sin(angle)+yp*Math.cos(angle);
		return {x:x, y:y};
	}
	function canSee(rc0:RoundCorner, rc1:RoundCorner):Boolean {
		// true if this roundCorner can see line segment rc0-rc1
		// see http://www.cse.unsw.edu.au/~lambert/java/3d/triangle.html
		// Here, this = P2, rc0=P0, rc1=P1
		var det = rc0._x*(rc1._y-_y);
		det -= rc1._x*(rc0._y-_y);
		det += _x*(rc0._y-rc1._y);
		if(isNaN(det)) {
			trace("rc0="+rc0+" @("+rc0._x+","+rc0._y+")");
			trace("rc1="+rc1+" @("+rc1._x+","+rc1._y+")");
		}
		//trace("canSee("+rc0.id+","+rc1.id+")="+det);
		//trace("det="+det);
		return (det<0);
	}
}
