﻿class PolyStyle {
	var _color: Number;
	var _thickness: Number;
	var _alpha: Number;
	var _fillType:String="none";
	var _fillColor:Number;
	var _fillColors:Array;
	var _fillAlpha:Number;
	var _fillAlphas:Array;
	var _fillRatios:Array;
	var _fillMatrix:Object;
	function PolyStyle(iObj:Object) {
		_color = iObj.color == null? 0: iObj.color;
		_thickness = iObj.thickness==null? 1: iObj.thickness;
		_alpha = iObj.alpha==null? 100: iObj.alpha;
		_fillType = iObj.fillType==null? "none": iObj.fillType;
		_fillColor = iObj.fillColor==null? 0: iObj.fillColor;
		_fillColors = iObj.fillColors.concat();
		_fillAlpha = iObj.fillAlpha==null? 50: iObj.fillAlpha;
		_fillAlphas = iObj.fillAlphas.concat();
	}
	function beginPoly(mc:MovieClip):Void {
		mc.lineStyle(_thickness, _color, _alpha);
		switch(_fillType) {
			case "none":
				break;
			case "solid":
				mc.beginFill(_fillColor, _fillAlpha);
				break;
			case "linear":
			case "radial":
				mc.beginGradientFill(_fillType, _fillColors, _fillAlphas, _fillRatios, _fillMatrix);
				break;
			}
	}
	function endPoly(mc:MovieClip):Void {
		if(_fillType=="none") {
			return;
		}
		mc.endFill();
	}
	function clone():PolyStyle {
		var cloneStyle:PolyStyle;
		for(var prop in this) {
			//trace(prop);
			cloneStyle[prop]=this[prop];
		}
		return cloneStyle;
	}
}