﻿class BandPointer extends Poly {
	var a:Number = 0;
	var b:Number = 8;
	var c:Number = -8;
	var band:Band = null;
	var bandButton:BandButton;
	var _active:Boolean;
	static var bandDepthAllocation:Number = 100;
	static var bandDepth:Number;
	static var top_mc:MovieClip;
	function BandPointer() {
	}
	function init(style:PolyStyle, bB:BandButton) {
		bandDepth = _level0.depth;
		_level0.depth += bandDepthAllocation;
		bandButton = bB;
		_style = style;
		_style.beginPoly(this);
		this.moveTo(a, c);
		this.curveTo(b, c, b, a);
		this.curveTo(b, b, a, b);
		this.curveTo(c, b, c, a);
		this.curveTo(c, c, a, c);
		_style.endPoly(this);
		top_mc = this;
	}
	function onPress() {
		activate();
	}
	function pegHit():Peg {
		for (var i = 0; i<Peg.pegs.length; i++) {
			var peg = Peg.pegs[i];
			if (peg.hitTest(_level0._xmouse, _level0._ymouse)) {
				return peg;
			}
		}
		return null;
	}
	function set active(b:Boolean) {
		_active = b;
		if (_active) {
			//_visible = true;
			_alpha = 100;
		} else {
			//_visible = false;
			_alpha = 20;
		}
	}
	function get active():Boolean {
		return _active;
	}
	function activate():Void {
		//trace("activate");
		active = true;
		swapDepths(top_mc);
		this.startDrag(true);
		if(band != null) {
			onMouseMove = function () {
				band.track();
			};
		}
	}
	function deactivate():Void {
		//trace("deactivate");
		this.stopDrag();
		active = false;
		onMouseMove = undefined;
		var peg = pegHit();
		if (peg != null) {
			//trace("Pressed on peg + "+peg.id);
			if (band == null) {
				band = Band(_level0.attachMovie("Band", "band"+bandDepth, ++bandDepth));
				band.init(_style, peg, this);
			}
			else {
				band.addPeg(peg);
			}
		}
	}
	function onRelease() {
		//trace("pointer release");
		//activate();
		release();
	}
	function onReleaseOutside() {
		//trace("pointer release outside");
		release();
	}
	function release() {
		deactivate();
	}
}
